% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OW.R
\name{OW}
\alias{OW}
\title{The Odd Weibull family}
\usage{
OW(mu.link = "log", sigma.link = "log", nu.link = "log")
}
\arguments{
\item{mu.link}{defines the mu.link, with "log" link as the default for the mu parameter.}

\item{sigma.link}{defines the sigma.link, with "log" link as the default for the sigma.}

\item{nu.link}{defines the nu.link, with "log" link as the default for the nu.}
}
\value{
Returns a gamlss.family object which can be used to fit a OW distribution in the \code{gamlss()} function.
}
\description{
The function \code{OW()} defines the Odd Weibull distribution, a three parameter 
distribution, for a \code{gamlss.family} object to be used in GAMLSS fitting 
using the function \code{gamlss()}.
}
\details{
The odd Weibull with parameters \code{mu}, \code{sigma} and \code{nu}
has density given by

\eqn{f(t) = \left( \frac{\sigma\nu}{t} \right) (\mu t)^\sigma
     e^{(\mu t)^\sigma} \left(e^{(\mu t)^{\sigma}}-1\right)^{\nu-1}
     \left[ 1 + \left(e^{(\mu t)^{\sigma}}-1\right)^\nu \right]^{-2}}

for \eqn{x>0}.
}
\examples{
# Example 1
# Generating some random values with
# known mu, sigma and nu
y <- rOW(n=200, mu=0.1, sigma=7, nu = 1.1)

# Fitting the model
require(gamlss)
mod <- gamlss(y~1, sigma.fo=~1, nu.fo=~1, family="OW",
              control=gamlss.control(n.cyc=500, trace=FALSE))

# Extracting the fitted values for mu, sigma and nu
# using the inverse link function
exp(coef(mod, what="mu"))
exp(coef(mod, what="sigma"))
exp(coef(mod, what="nu"))

# Example 2
# Generating random values under some model
n <- 200
x1 <- runif(n)
x2 <- runif(n)
x3 <- runif(n)
mu <- exp(1.2 + 2 * x1)
sigma <- 2.12 + 3 * x2
nu <- exp(0.2 - x3)
y <- rOW(n=n, mu, sigma, nu)

mod <- gamlss(y~x1, sigma.fo=~x2, nu.fo=~x3, 
              family=OW(sigma.link="identity"), 
              control=gamlss.control(n.cyc=300, trace=FALSE))

coef(mod, what="mu")
coef(mod, what="sigma")
coef(mod, what="nu")
}
\references{
Cooray, K. (2006). Generalization of the Weibull distribution: 
the odd Weibull family. Statistical Modelling, 6(3), 265-277.
}
\author{
Jaime Mosquera Gutiérrez \email{jmosquerag@unal.edu.co}
}
