% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppGreedySetCover.R
\docType{package}
\name{RcppGreedySetCover-package}
\alias{RcppGreedySetCover}
\alias{RcppGreedySetCover-package}
\title{Fast Greedy Set Cover}
\description{
This package offers an implementation of the greedy algorithm for the set cover problem using Rcpp.
}
\section{Set Cover Problem}{
 
We are given a universe of elements \emph{U} and \emph{F}, 
a collection of subsets from \emph{U}, covering \emph{U}; i.e. \emph{U} is 
in the union of the sets in \emph{F}.
The objective is to find \emph{A}, the smallest subcollection of \emph{F}, covering \emph{U}.
An important application is hospital placement, where the 
number of hospitals is minimized under the constraint that all residents are provided for.

The optimal solution to the problem is available via linear programming, 
however this is not a feasible solution for large 
problems due to the computational demands involved. 
A quick approximate solution is given by the greedy algorithm. 
The algorithm iterates the following steps until all elements are covered, 
starting from an empty \emph{A}:
\itemize{
  \item Add the largest set of uncovered elements to \emph{A}.
  \item Remove covered elements from \emph{F}.
}
This simple algorithm exhibits surprisingly good properties. 
For a nice introduction to the set cover problem and the greedy algorithm see Vazirani, 2001.
}

\references{
Vazirani, Vijay V. (2001), Approximation Algorithms, Springer
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/matthiaskaeding/setcover/tree/main/rcpp_greedy_set_cover/}
  \item Report bugs at \url{https://github.com/matthiaskaeding/setcover/issues}
}

}
\author{
\strong{Maintainer}: Matthias Kaeding \email{matthiaskaeding@posteo.de}

}
\keyword{internal}
