% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zookin_accessor.R
\name{predhbd}
\alias{predhbd}
\title{Extracts the IBD probabilities from the kres object}
\usage{
predhbd(
  kres,
  zooin,
  num,
  chrom = NULL,
  startPos = NULL,
  endPos = NULL,
  T = FALSE
)
}
\arguments{
\item{kres}{The name of the kres object created by the zookin function.}

\item{zooin}{The name of the zdata object created by the zoodata function. See
"zoodata" for more details.}

\item{num}{The number of the pair of individuals to extract (correspond to the
position in the list of pairs).}

\item{chrom}{the number of the chromosome where we are looking for IBD
segments. This chromosome number refers to the position of the chromosome in
the list of all chromsomes present in the input genotype data.}

\item{startPos}{The starting position (on the chromosome) of the interval from
which we will extract IBD segments (1 by default).}

\item{endPos}{The ending position (on the chromosome) of the interval from
which we will extract IBD segments (last position by default).}

\item{T}{The value chosen to define the base population (to determine which
classes are used in estimated of IBD probability, which classes are
considered autozygous). When T is not provided, all IBD classes are
considered to estimate the local IBD probability.}
}
\value{
The function returns a vector of IBD probabilities averaged over the
 four combination of pairs of parental haplotypes for the specified pair of
 individuals and chromosomal region. The IBD probabilities are computed as
 the sum of the probabilities for each class with a rate smaller or equal
 than the threshold (the sum from all the IBD classes when T is not
 specified).
}
\description{
Extracts the locus specific IBD probabilities for a pair of individuals. This
is the probability that one pair of chromosomes (one sampled in each
individual) are IBD at that position. A specific chromosomal region can be
specified. A threshold T can be used to determine which classes are used in
the computation of the IBD probability. This function requires that the option
"localhbd" was set to TRUE when creating the kres object.
}
