/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.modelling.arima.AbstractModelController;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.modelling.arima.ProcessingResult;
import ec.tstoolkit.modelling.arima.tramo.ModelComparator;
import ec.tstoolkit.modelling.arima.tramo.ModelVerifier;
import ec.tstoolkit.sarima.SarimaSpecification;

public class ModelBenchmarking
extends AbstractModelController {
    @Override
    public ProcessingResult process(ModellingContext context) {
        PreprocessingModel current = context.tmpModel();
        SarimaSpecification spec = current.description.getSpecification();
        if (spec.isAirline(context.hasseas)) {
            return ProcessingResult.Unchanged;
        }
        ModelVerifier verifier = new ModelVerifier();
        if (verifier.accept(context)) {
            return ProcessingResult.Unchanged;
        }
        ModellingContext scontext = new ModellingContext();
        scontext.description = current.description.clone();
        scontext.description.setAirline(context.hasseas);
        scontext.description.setMean(context.hasseas ? context.description.isMean() : true);
        scontext.description.setOutliers(null);
        if (!this.estimate(scontext, true)) {
            return ProcessingResult.Failed;
        }
        PreprocessingModel smodel = scontext.tmpModel();
        int cmp = new ModelComparator().compare(current, smodel);
        if (cmp < 1) {
            return ProcessingResult.Unchanged;
        }
        this.transferInformation(scontext, context);
        return ProcessingResult.Changed;
    }
}

