% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd_query.R
\name{rd_query}
\alias{rd_query}
\title{Identification of Queries}
\usage{
rd_query(
  project = NULL,
  variables = NA,
  expression = NA,
  negate = FALSE,
  event = NA,
  filter = NA,
  addTo = NA,
  variables_names = NA,
  query_name = NA,
  instrument = NA,
  report_title = NA,
  report_zeros = FALSE,
  by_dag = FALSE,
  link = list(),
  data = NULL,
  dic = NULL,
  event_form = NULL
)
}
\arguments{
\item{project}{A list containing the REDCap data, dictionary, and event mapping (expected \code{redcap_data()} output). Overrides \code{data}, \code{dic}, and \code{event_form}.}

\item{variables}{Character vector of variable names to check for queries.}

\item{expression}{Character vector of R expressions to evaluate for each variable.}

\item{negate}{Logical, if \code{TRUE}, identifies values that \strong{do not} meet the condition. Default is \code{FALSE}.}

\item{event}{Required for longitudinal projects to avoid overestimation. REDCap event(s) to analyze.}

\item{filter}{Optional string of filters to apply to the dataset, such as the branching logic of a variable.}

\item{addTo}{Optional data frame from a previous query report to which the new results can be appended.}

\item{variables_names}{Optional character vector of descriptions for each variable. Defaults to the variables labels in the dictionary.}

\item{query_name}{Optional character vector describing each query. Defaults to a standard format: \verb{The value is [value] and it should not be [expression]}.}

\item{instrument}{Optional REDCap instrument(s) for each variable. Defaults to the instrument reported in the dictionary.}

\item{report_title}{Optional string specifying the title of the final report. Defaults to \code{"Report of queries"}.}

\item{report_zeros}{Logical, include variables with zero queries in the report. Default is \code{FALSE}.}

\item{by_dag}{Logical, split results by Data Access Group (DAG). Default is \code{FALSE}.}

\item{link}{Optional list containing project information (\code{domain}, \code{redcap_version}, \code{proj_id}, \code{event_id}) to generate clickable links for each query.}

\item{data}{A \code{data.frame} or \code{tibble} with the REDCap dataset.}

\item{dic}{A \code{data.frame} with the REDCap dictionary.}

\item{event_form}{Only applicable for longitudinal projects (presence of events). Event-to-form mapping for longitudinal projects.}
}
\value{
A list containing:
\describe{
\item{queries}{A data frame or a list of data frames (if \code{by_dag = TRUE}) with detailed query information for each record.}
\item{results}{A formatted report (HTML table) summarizing total queries per variable, event, and DAG if applicable.}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Detects and summarizes queries in a REDCap dataset based on specified expressions, filters, or a defined branching logic. Useful for identifying missing values, out-of-range values, or values that do not meet predefined criteria.
}
\details{
The function performs the following steps:
\itemize{
\item Applies user-specified expressions to the selected variables to detect queries.
\item Optionally negates the expressions to find values that \strong{do not} satisfy the condition.
\item Handles REDCap branching logic, converting it into R-compatible expressions for evaluation.
\item Applies additional user-specified filters before identifying queries.
\item Generates structured query results with metadata including:
\itemize{
\item Identifier (record_id)
\item DAG (if present)
\item Event and Instrument
\item Field, Repetition, Description, Query statement
\item Optional link to REDCap entry
}
\item Optionally combines results with previous query outputs using \code{addTo}.
\item Produces a summarized report, optionally including variables with zero queries.
\item Provides warnings for variables with branching logic that could not be automatically evaluated.
}
}
\examples{
\dontrun{
# Identify missing values for multiple variables
result <- rd_query(covican,
  variables = c("copd", "age"),
  expression = c("is.na(x)", "x \%in\% NA"),
  event = "baseline_visit_arm_1"
)
result$results

# Identify values exceeding a threshold
result <- rd_query(covican,
  variables = "age",
  expression = "x > 20",
  event = "baseline_visit_arm_1"
)

# Apply a filter to select subset of data
result <- rd_query(covican,
  variables = "potassium",
  expression = "is.na(x)",
  event = "baseline_visit_arm_1",
  filter = "available_analytics == '1'"
)
}

}
