% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Qhot.EQF.R
\name{Qhot.EQF}
\alias{Qhot.EQF}
\title{EQF Matrix Conversion}
\usage{
Qhot.EQF(
  DataQTL,
  Datachr,
  bin.size = 0.5,
  permu = TRUE,
  ptime = 1000,
  alpha = 0.05,
  Q = TRUE,
  console = interactive()
)
}
\arguments{
\item{DataQTL}{data.frame. A data frame with 5 columns for QTL information.
The columns represent the serial number of QTLs, the trait names, the
chromosome numbers, the left flanking marker positions(in cM) of QTLs, and
the right flanking marker positions(in cM) of QTLs.}

\item{Datachr}{vector. The length of each chromosome(in cM).}

\item{bin.size}{numeric. The bin size(in cM) for QTL detection. If the
distance of flanking marker of a QTL is lass than the bin size, it will be
mark in the EQF matrix and will participate in the cluster grouping process.}

\item{permu}{logical. When set to TRUE, the function will carry out the
cluster grouping process and cluster group permutation.}

\item{ptime}{integer. The permutation times.}

\item{alpha}{numeric. The type 1 error rate of detecting the hotspot.}

\item{Q}{logical. When set to TRUE, the function will additionally carry
out the permutation of the Q method as the control group, which will be
indicated as 'B' in the output.}

\item{console}{logical. Determines whether the process of the algorithm
will be displayed in the R console or not.}
}
\value{
\item{EQF.matrix}{The matrix denotes the EQF value of each bin for every
QTL in this database.}
\item{bin}{The bin information matrix whose first column denotes the
chromosome number and the second column denotes the number of bins on
that chromosome.}
\item{bin.size}{The bin size set in this analysis.}
\item{EQF.trait}{The matrix denotes the EQF value of each bin for every
trait of this database.}
\item{EQF.detect}{The matrix denotes the EQF value of each bin for the
trait that have the QTL detected in the set bin size.}
\item{EQF.nondetect}{The matrix denotes the EQF value of each bin for the
trait that have no QTL detected in the set bin size.}
\item{cluster.matrix}{The new EQF matrix after the clustering process.}
\item{permu.matrix.cluster}{The permutation result of the clustering
method, which has been sorted by order.}
\item{permu.matrix.Q}{The permutation result of the Q method, which has
been sorted by order.}
\item{EQF.threshold}{The EQF threshold is calculated from the
permutation process.}
}
\description{
Convert the QTL flanking marker data to EQF matrix. And the EQF matrix
cluster permutation process can be further carried out to detect QTL
hotspots.
}
\examples{
# load the example data
load(system.file("extdata", "QHOTEQFexample.RDATA", package = "QTLEMM"))

#' # run and result
result <- Qhot.EQF(QTL.example, chr.example, bin.size = 2, permu = TRUE,
ptime = 100, alpha = 0.05, Q = FALSE)
}
\references{
Wu, P.-Y., M.-.H. Yang, and C.-H. KAO 2021 A Statistical Framework
for QTL Hotspot Detection. G3: Genes, Genomes, Genetics: jkab056. <doi: 10.1093/g3journal/jkab056>
}
\seealso{
\code{\link[QTLEMM]{Qhot}}
\code{\link[QTLEMM]{EQF.plot}}
}
