% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_data_processing.R
\name{shrinkflation}
\alias{shrinkflation}
\title{Detecting and summarising downsized and upsized products.}
\usage{
shrinkflation(
  data,
  start,
  end,
  type = "shrinkflation",
  min_p_change = 0,
  max_p_change = Inf,
  min_s_change = 0,
  max_s_change = Inf,
  prec = 3,
  interval = FALSE
)
}
\arguments{
\item{data}{The user's data frame with information about sold products. It must contain columns: \code{time} (as Date in format: year-month-day,e.g. '2020-12-01') and \code{prodID} (as numeric, factor or character), \code{prices} (with standardised prices!) and \code{quantities} (as numeric), \code{grammage} (as numeric), \code{unit} (as character) and \code{description} (as character). Important: prices must be standardized beforehand, that is, they must refer to the sales unit (the \code{data_norm} function can be used for this).}

\item{start}{The base period (as character) limited to the year and month, e.g. "2024-01".}

\item{end}{The research period (as character) limited to the year and month, e.g. "2024-02".}

\item{type}{A parameter specifying what phenomenon is to be included in the resulting elements of the returned list (i.e. in returned \code{products_detected}, \code{df_detected} and \code{df_reduced}). The available values are: \code{shrinkflation}, \code{shrinkdeflation}, \code{sharkflation}, \code{unshrinkdeflation}, \code{unshrinkflation} and \code{sharkdeflation} (default value is: \code{shrinkflation}).}

\item{min_p_change}{Lower limit for unit price change, i.e.: a product is considered if the percentage change in its unit price is greater than the value of this parameter. The default value is zero, possibly positive values can be considered (in percentage).}

\item{max_p_change}{Upper limit for unit price change, i.e.: a product is considered if the percentage change in its unit price is less than the value of this parameter. The default value is Inf, possibly positive values can be considered (in percentage).}

\item{min_s_change}{Lower limit for size change, i.e.: a product is considered if the percentage change in its size is greater than the value of this parameter. The default value is zero, possibly positive values can be considered (in percentage).}

\item{max_s_change}{Upper limit for size change, i.e.: a product is considered if the percentage change in its size is less than the value of this parameter. The default value is Inf, possibly positive values can be considered (in percentage).}

\item{prec}{Number of decimal places for the presented summary results.}

\item{interval}{A parameter that specifies whether the search for downsized products should consider the entire time interval, or only the compared months specified by the \code{start} and \code{end} parameters.}
}
\value{
This function detects and summarises downsized and upsized products. The function detects phenomena such as: \code{shrinkflation}, \code{shrinkdeflation}, \code{sharkflation}, \code{unshrinkdeflation}, \code{unshrinkflation}, \code{sharkdeflation} (see the \code{type} parameter). It returns a list containing the following objects: \code{df_changes} - data frame with detailed information on downsized and upsized products with the whole history of size changes, \code{df_type} - data frame with recognized type of products, \code{df_overview} - a table with basic summary of all detected products grouped by the \code{type} parameter, \code{products_detected} with prodIDs of products indicated by the 'type' parameter, \code{df_detected} being a subset of the data frame with only detected products, \code{df_reduced} which is the difference of the input data frame and the data frame containing the detected products, 
and \code{df_summary} which provides basic statistics for all detected downsized and upsized products (including their share in the total number of products and mean price and size changes).
}
\description{
This function detects and summarises downsized and upsized products.
}
\examples{
#Data matching over time
\donttest{df<-data_matching(data=data_DOWN_UP_SIZED, start="2024-01", end="2024-02", 
codeIN=TRUE,codeOUT=TRUE,description=TRUE, 
onlydescription=FALSE,precision=0.9,interval=FALSE)}
# Extraction of information about grammage (if needed)
\donttest{df<-data_unit(df,units=c("g|ml|kg|l"),multiplication="x")}
# Price standardization
\donttest{df<-data_norm(df, rules=list(c("ml","l",1000),c("g","kg",1000)))}
# Downsized and upsized products detection
\donttest{result<-shrinkflation(data=df, start="2024-01","2024-02", 
prec=3, interval=FALSE, type="shrinkflation")}
\donttest{result$df_changes}
\donttest{result$df_type}
\donttest{result$df_overview}
\donttest{result$products_detected}
\donttest{result$df_detected}
\donttest{result$df_reduced}
\donttest{result$df_summary}

}
\references{
{Białek, J., Bobel, A., Oprych-Franków D. (2024). \emph{Immeasurability of shrinkflation in the CPI? Automatic downsizing detection using scanner data}. 18th Meeting of the Ottawa Group, Ottawa.}

{Białek, J., Bobel, A., Oprych-Franków D. (2025). \emph{Automatic downsizing and upsizing detection using scanner data and their impact on price indices}. Statistical Journal of the IAOS, 41(3):858-872.}
}
