% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixhours.R
\name{fixhours}
\alias{fixhours}
\title{Reallocates working hours between people in education and people not in education}
\usage{
fixhours(people, pplid, pplstat, pplhours, hoursmax, grpdef, userseed = NULL)
}
\arguments{
\item{people}{A data frame containing individual people.}

\item{pplid}{The variable containing the unique identifier for each person, in the people data frame.}

\item{pplstat}{The variable containing the indicator of whether a person is in education, in the people data frame. This must consist of only two values, and can be either an ordered factor or numeric. If this is a factor, factor level 2 must be for those in education. If it is a numeric variable, the lowest number must be for those in education.}

\item{pplhours}{The variable containing the hours worked by each adolescent. Must be a factor or numeric. If this is a factor, it is assumed to be ordered. The levels/values must be ascending for hours worked.}

\item{hoursmax}{The maximum hours worked by people in education. Must be the relevant factor level/number from pplhours.}

\item{grpdef}{The vector containing any grouping variable to be used. If this is used, the changes to the working hours will be performed using grouped data. Marginal totals for the cross-tabulations of the grouping variables are retained.}

\item{userseed}{If specified, this will set the seed to the number provided. If not, the normal set.seed() function will be used.}
}
\value{
A data of observations, with working hours reallocated so that people's working hours are compatible with their education status.
}
\description{
Reallocates working hours so that people in education work fewer hours than people not in education. Pre-cleaning so that only people inside the student age range is not required. The hours of work are reallocated so that shorter hours worked are prioritised to those in education. The variables provided in the grpdef vector define the marginal totals that must be retained.
}
\examples{

# table of hours by schoolstatus
table(WorkingAdolescents$HoursWorked, WorkingAdolescents$SchoolStatus)

# one grouping variable
Group1 <- "Age"
OneGroup <- fixhours(WorkingAdolescents, pplid = "ID", pplstat = "SchoolStatus",
                     pplhours = "HoursWorked", hoursmax = 3, grpdef = Group1, userseed = 4)
table(OneGroup$HoursWorked, OneGroup$SchoolStatus)

# two grouping variables
Group2 <- c("Age", "Sex")
TwoGroups <- fixhours(WorkingAdolescents, pplid = "ID", pplstat = "SchoolStatus",
                      pplhours = "HoursWorked", hoursmax = 3, grpdef = Group2, userseed = 4)
table(TwoGroups$HoursWorked, TwoGroups$SchoolStatus)
}
