% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_classes.R
\name{fit_classes}
\alias{fit_classes}
\title{\strong{LP_fit}, \strong{LP_IS_fit}, \strong{LP_SPAS_cit}, \strong{CL_fit}, \strong{LP_BTSPAS_fit_Diag}, \strong{LP_BTSPAS_fit_NonDiag}, \strong{LP_CL_fit} classes.}
\usage{
fit_classes()
}
\value{
NOTHING. This is not a function, but only documents how I use "classes".
}
\description{
We assign a "class" (one of the classes above) to the results from one of the fitting methods. This class
designation is \strong{only used to ensure that estimation routines have the correct type of fit when finding estimates of abundance},
and \strong{model averaging only considers models of comparable class} when creating the
model averaging results of abundance.
}
\details{
The structure of an object of the above classes is roughly comparable across classes. The object should be a
list with the following objects
\itemize{
\item \strong{summary} A data frame with the model for the parameters of the model;
the conditional log-likelihood; the number of parameters; the number of parameters, and method used to fit the model
\item \strong{data} A data frame with the raw data used in the fit
\item \strong{fit} Results of the fit including the estimates, SE, vcov, etc.
\item \strong{datetime} Date and time the fit was done
}

Other objects may also be included in the list.

After a fit performed, estimates of \strong{ABUNDANCE} are extracted using the \strong{xxx_est()} function corresponding to the \strong{xxx_fit()} function
used to estimate parameters. This separation occurs because
\itemize{
\item abundance is a derived estimate; the fits are based on conditional likelihood (on
the observed data) and the abundance parameter does not appear in the conditional likelihood. Abundance is usually
estimated using a variation of a Horvitz-Thompson estimator.
\item you can obtain estimates of overall abundance, subsets of the population (e.g., sex or other strata) from the same fit, and
so you don't need to do several fits to get several estimates of abundance.
}
}
