% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specification.R
\name{LinTest}
\alias{LinTest}
\alias{WCB_LinTest}
\title{Linearity (homogeneity) tests for PSTR models}
\usage{
LinTest(use)

WCB_LinTest(use, iB = 100, parallel = FALSE, cpus = 2)
}
\arguments{
\item{use}{An object of class \code{"PSTR"} created by \code{\link{NewPSTR}}.}

\item{iB}{Integer. Number of bootstrap repetitions. Default is \code{100}.}

\item{parallel}{Logical. Whether to use parallel computation in bootstrap routines.}

\item{cpus}{Integer. Number of CPU cores to use when \code{parallel = TRUE}. Ignored otherwise.}
}
\value{
Both functions return \code{use} invisibly, after adding the following components:
\describe{
  \item{\code{test}}{List. Asymptotic linearity test results for each transition variable and \eqn{m}.}
  \item{\code{sqtest}}{List. Asymptotic sequence test results for each transition variable and \eqn{m}.}
  \item{\code{wcb_test}}{List (only for \code{WCB_LinTest}). WB and WCB p-values for the linearity tests.}
  \item{\code{wcb_sqtest}}{List (only for \code{WCB_LinTest}). WB and WCB p-values for the sequence tests.}
}
}
\description{
These functions conduct linearity (homogeneity) tests against the alternative of
a logistic smooth transition component in a Panel Smooth Transition Regression (PSTR) model.
}
\details{
\strong{Two equivalent interfaces are available:}
\enumerate{
  \item \strong{Wrapper functions:} \code{LinTest(use = obj)} and \code{WCB_LinTest(use = obj, ...)}.
  \item \strong{R6 methods:} \code{obj$LinTest()} and \code{obj$WCB_LinTest(...)}.
}
The wrapper functions call the corresponding R6 methods and return the (mutated) object invisibly.

The tests are carried out for each potential transition variable specified in \code{tvars}
when creating the model via \code{\link{NewPSTR}}. For each transition variable, tests are computed
for the number of switches \eqn{m = 1, \ldots, im}, where \eqn{im} is the maximal number of switches.

The procedures produce two families of tests:
\describe{
  \item{(i) Linearity tests for each \eqn{m}}{
    For a fixed \eqn{m}, the null hypothesis is
    \deqn{H_0^i: \beta_{i} = \beta_{i-1} = \cdots = \beta_{1} = 0, \qquad i = 1, \ldots, m.}
  }
  \item{(ii) Sequence tests for selecting \eqn{m}}{
    These are conditional tests with null
    \deqn{H_0^i: \beta_{i} = 0 \mid \beta_{i+1} = \cdots = \beta_{m} = 0, \qquad i = 1, \ldots, m.}
  }
}

For each hypothesis, four asymptotic LM-type tests are reported:
\itemize{
  \item \eqn{\chi^2}-version LM test.
  \item F-version LM test.
  \item \eqn{\chi^2}-version HAC LM test (heteroskedasticity and autocorrelation consistent).
  \item F-version HAC LM test.
}

\code{WCB_LinTest} additionally reports wild bootstrap (WB) and wild cluster bootstrap (WCB) p-values.
WB is robust to heteroskedasticity, while WCB is robust to both heteroskedasticity and within-individual
dependence (cluster dependence). The bootstrap routines can be computationally expensive; parallel execution
can be enabled via \code{parallel = TRUE}.

Results are stored in the returned object (see \strong{Value}).
}
\examples{
pstr <- NewPSTR(Hansen99, dep = "inva", indep = 4:20,
               indep_k = c("vala","debta","cfa","sales"),
               tvars = c("vala"), iT = 14)

# R6 method interface
pstr$LinTest()

# Wrapper interface (equivalent)
pstr <- LinTest(pstr)

# Show results
print(pstr, mode = "tests")

\donttest{
# Bootstrap tests (can be slow)
pstr$WCB_LinTest(iB = 200, parallel = TRUE, cpus = 2)
# or
pstr <- WCB_LinTest(use = pstr, iB = 200, parallel = TRUE, cpus = 2)

print(pstr, mode = "tests")
}

}
\seealso{
\code{\link{NewPSTR}}, \code{\link{EstPSTR}}, \code{\link{EvalTest}}.
}
