% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PEAXAI_predict.R
\name{PEAXAI_predict}
\alias{PEAXAI_predict}
\title{Predict Probability of Efficiency Using a Fitted Model}
\usage{
PEAXAI_predict(data, x, y, final_model, calibration_model = NULL)
}
\arguments{
\item{data}{A \code{data.frame} or \code{matrix} containing the variables used
for prediction.}

\item{x}{Integer vector indicating the column indices of input variables in
\code{data}.}

\item{y}{Integer vector indicating the column indices of output variables in
\code{data}.}

\item{final_model}{A fitted \pkg{caret} model provided by PEAXAI_fitting().}

\item{calibration_model}{Optional calibration object returned by \code{PEAXAI_fitting()}.
If \code{NULL}, raw probabilities are returned. If \code{calibration_model$method == "glm.fit"},
Platt scaling is applied by predicting \code{type = "response"} from a logistic regression
using the raw score \code{s}. Otherwise, an isotonic calibration function is retrieved via
\code{calibration_model[[final_model$method]]} and applied to the raw probabilities.}
}
\value{
A numeric vector of predicted probabilities (raw or calibrated), one per
row of \code{data}.
}
\description{
Predicts probabilities for new decision-making units (DMUs) using a fitted
\pkg{caret} classification model. If \code{calibration_model} is provided,
the raw classifier probabilities are post-processed to obtain calibrated
probability estimates (e.g., Platt scaling via logistic regression or
isotonic calibration via a monotone mapping).
}
