% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_values_from_tables.R
\name{extract_values_from_tables}
\alias{extract_values_from_tables}
\title{Extract values from tables within text}
\usage{
extract_values_from_tables(
  lines,
  mutations,
  genes_mutated = list(),
  pathogenicity = list(),
  frequencies = list(),
  codifications = list(),
  changes = list(),
  values = list(),
  start = "Variantes de secuencia de ADN",
  start2 = "   Variaciones del número de copias",
  end = "Genes analizados",
  end2 = "Comentarios adicionales sobre las variantes"
)
}
\arguments{
\item{lines}{Character vector. Lines of text to process.}

\item{mutations}{Character vector. List of known mutation identifiers.}

\item{genes_mutated}{Ordered list to store extracted gene data.}

\item{pathogenicity}{Ordered list to store extracted pathogenicity information.}

\item{frequencies}{Ordered list to store extracted frequency data.}

\item{codifications}{Ordered list to store extracted codification data.}

\item{changes}{Ordered list to store extracted changes data.}

\item{values}{Aggregated list of extracted information.}

\item{start}{Starting marker for the relevant table section.}

\item{start2}{Secondary starting marker for the table section, in case the table is divided in two pages.}

\item{end}{text marker indicating the end of the subset.}

\item{end2}{secondary end marker.}
}
\value{
A list containing extracted data: genes, pathogenicity, frequencies, codifications and changes.
}
\description{
This function analyzes a subset of text lines, extracting information such as mutations, pathogenicity, frequencies, codifications and changes.
}
\examples{
InputPath <- system.file("extdata", package = "ORscraper")
files <- read_pdf_files(InputPath)
lines <- read_pdf_content(files[1])  # Example with the first file

genes_file <- system.file("extdata/Genes.xlsx", package = "ORscraper")
genes <- readxl::read_excel(genes_file)
mutations <- unique(genes$GEN)

TableValues <- extract_values_from_tables(lines, mutations)
mutateGenes <- TableValues[[1]]
pathogenity <- TableValues[[2]]
frequencies <- TableValues[[3]]
codifications <- TableValues[[4]]
changes <- TableValues[[5]]

}
