% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoissonInvNHE.r
\name{PoissonInvNHE}
\alias{PoissonInvNHE}
\alias{dpois.inv.NHE}
\alias{ppois.inv.NHE}
\alias{qpois.inv.NHE}
\alias{rpois.inv.NHE}
\alias{hpois.inv.NHE}
\title{Poisson Inverse NHE Distribution}
\usage{
dpois.inv.NHE(x, alpha, beta, lambda, log = FALSE)
ppois.inv.NHE(q, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
qpois.inv.NHE(p, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
rpois.inv.NHE(n, alpha, beta, lambda)
hpois.inv.NHE(x, alpha, beta, lambda)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{beta}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dpois.inv.NHE}: numeric vector of (log-)densities
  \item \code{ppois.inv.NHE}: numeric vector of probabilities
  \item \code{qpois.inv.NHE}: numeric vector of quantiles
  \item \code{rpois.inv.NHE}: numeric vector of random variates
  \item \code{hpois.inv.NHE}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Poisson Inverse NHE distribution.
}
\details{
The Poisson Inverse NHE distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\beta > 0}, and \eqn{\lambda > 0}.


The Poisson Inverse NHE distribution has CDF:

\deqn{
F(x; \alpha, \beta, \lambda) =
\quad \frac{1-\exp \left[-\lambda \exp \left\{1-(1+\alpha / x)
^\beta\right\}\right]}{1-\exp (-\lambda)} \quad ;\;x > 0.
}

where \eqn{\alpha}, \eqn{\beta}, and \eqn{\lambda} are the parameters.

The following functions are included:
\itemize{
  \item \code{dpois.inv.NHE()} — Density function
  \item \code{ppois.inv.NHE()} — Distribution function
  \item \code{qpois.inv.NHE()} — Quantile function
  \item \code{rpois.inv.NHE()} — Random generation
  \item \code{hpois.inv.NHE()} — Hazard function
}
}
\examples{
x <- seq(0.1, 10, 0.2)
dpois.inv.NHE(x, 2.0, 0.5, 0.2)
ppois.inv.NHE(x, 2.0, 0.5, 0.2)
qpois.inv.NHE(0.5, 2.0, 0.5, 0.2)
rpois.inv.NHE(10, 2.0, 0.5, 0.2)
hpois.inv.NHE(x, 2.0, 0.5, 0.2)

# Data
x <- fibers63
# ML estimates
params = list(alpha=1.0174, beta=5.1414, lambda=23.3476)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = ppois.inv.NHE, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qpois.inv.NHE, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dpois.inv.NHE, pfun=ppois.inv.NHE, plot=FALSE)
print.gofic(out)

}
\references{
Chaudhary,A.K.& Kumar, V.(2020). 
Poisson Inverse NHE Distribution. 
\emph{International Journal of Science and Research(IJSR)}, 
\bold{9(12)}, 1603--1610.
}
