% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExpoInvChen.r
\name{ExpoInvChen}
\alias{ExpoInvChen}
\alias{dexpo.inv.chen}
\alias{pexpo.inv.chen}
\alias{qexpo.inv.chen}
\alias{rexpo.inv.chen}
\alias{hexpo.inv.chen}
\title{Exponentiated Inverse Chen Distribution}
\usage{
dexpo.inv.chen(x, alpha, lambda, theta, log = FALSE)
pexpo.inv.chen(q, alpha, lambda, theta, lower.tail = TRUE, log.p = FALSE)
qexpo.inv.chen(p, alpha, lambda, theta, lower.tail = TRUE, log.p = FALSE)
rexpo.inv.chen(n, alpha, lambda, theta)
hexpo.inv.chen(x, alpha, lambda, theta)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{theta}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dexpo.inv.chen}: numeric vector of (log-)densities
  \item \code{pexpo.inv.chen}: numeric vector of probabilities
  \item \code{qexpo.inv.chen}: numeric vector of quantiles
  \item \code{rexpo.inv.chen}: numeric vector of random variates
  \item \code{hexpo.inv.chen}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Exponentiated Inverse Chen distribution.
}
\details{
The Exponentiated Inverse Chen distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\lambda > 0}, and \eqn{\theta > 0}.


The Exponentiated Inverse Chen distribution has CDF:

\deqn{
F(x; \alpha, \lambda, \theta)
= 1 - \left[ 1 - \exp\left( \lambda \left( 1 - \exp(x^{-\alpha}) \right) \right) \right]^{\theta},
\quad x > 0.
}

where \eqn{\alpha}, \eqn{\lambda}, and \eqn{\theta} are the parameters.

The functions available are listed below:
\itemize{
  \item \code{dexpo.inv.chen()} — Density function
  \item \code{pexpo.inv.chen()} — Distribution function
  \item \code{qexpo.inv.chen()} — Quantile function
  \item \code{rexpo.inv.chen()} — Random generation
  \item \code{hexpo.inv.chen()} — Hazard function
}
}
\examples{
x <- seq(2, 5, 0.25)
dexpo.inv.chen(x, 0.5, 2.5, 1.5)
pexpo.inv.chen(x, 0.5, 2.5, 1.5)
qexpo.inv.chen(0.5, 0.5, 2.5, 1.5)
rexpo.inv.chen(10, 0.5, 2.5, 1.5)
hexpo.inv.chen(x, 0.5, 2.5, 1.5)

# Data
x <- headneck44
# ML estimates
params = list(alpha=0.3947, lambda=15.5330, theta=8.1726)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = pexpo.inv.chen, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qexpo.inv.chen, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
# Display plot and print numerical summary
gofic(x, params = params,
      dfun = dexpo.inv.chen, pfun=pexpo.inv.chen, plot=TRUE, verbose = TRUE)

}
\references{
Telee, L. B. S., & Kumar, V. (2023). 
Exponentiated Inverse Chen distribution: Properties and applications. 
\emph{Journal of Nepalese Management Academia}, \bold{1(1)}, 53--62. 
\doi{10.3126/jnma.v1i1.62033}

Srivastava, A.K., & Kumar, V.(2011). 
Markov Chain Monte Carlo Methods for Bayesian Inference of the Chen Model. 
\emph{International Journal of Computer Information Systems}, \bold{2(2)}, 7--14.
}
