#' Compute Residuals for NNMoMo Fitted Models
#'
#' This function computes the residuals for objects created by
#' \code{\link{fit.NNMoMo}}.
#' It is analog to the \code{\link[StMoMo]{residuals.fitStMoMo}} function for
#' \pkg{StMoMo} but without the option to scale the residuals as \code{nobs} and
#' \code{npar} are not provided by the neural network.
#'
#' @param object An object of class \code{fitNNMoMo} with the fitted parameters
#' of a stochastic mortality model.
#' @param scale Logical, default \code{FALSE}. If \code{TRUE}, an error is
#' thrown because the number of observations (\code{nobs}) and parameters
#' (\code{npar}) cannot be calculated for \code{fitNNMoMo} objects.
#' @param ... Further arguments passed to or from other methods.
#'
#' @return An object of class \code{resStMoMo} with the residuals. This object
#' has components:
#' \itemize{
#'   \item \code{residuals}: a matrix with the residuals.
#'   \item \code{ages}: ages corresponding to the rows in \code{residuals}.
#'   \item \code{years}: years corresponding to the columns in \code{residuals}.
#' }
#'
#' @export
residuals.fitNNMoMo <- function (object, scale = FALSE, ...)
{
  if (scale == TRUE){
    stop(
      paste(
        "'scale = TRUE' is not allowed for objects from fit.NNMoMo().",
        "Residuals cannot be scaled when using a neural network."
      )
    )
  }

  NextMethod("residuals", scale = scale)
}
