$PROBLEM    Demo run. Multiple tables, meta data.

;@ Variables 18/20 @;
$INPUT ROW ID TIME EVID CMT AMT DV MDV

$DATA ./NMsimData_xgxr021_subprobs.csv
IGN=@

$SUBROUTINE ADVAN4 TRANS4

$PK
KA=THETA(1)*EXP(ETA(1))
V2=THETA(2)*EXP(ETA(2))
CL=THETA(3)*EXP(ETA(3))
V3=THETA(4)*EXP(ETA(4))
Q=THETA(5)*EXP(ETA(5))

$ERROR
  IPRED = F
  IRES  = DV-IPRED
  
  IF (IPRED.GT.1) THEN
    W = SQRT(IPRED**2*SIGMA(1,1)**2 + SIGMA(2,2)**2)
  ELSE
    W = 1
  ENDIF

  IWRES = IRES/W
  Y     = F+F*ERR(1)+ERR(2)

;-----------------------INITIAL ESTIMATES---------------------------------
$THETA
0.181196 FIX
0.042 FIX
0.724569 FIX
0.178477 FIX
2307450 FIX

$OMEGA 0.209981
$OMEGA 0.121443
$OMEGA 0.00016905
$OMEGA 0 FIX
$OMEGA 0 FIX

$SIGMA 0.105902
$SIGMA 0.0013928



$SIMULATION ONLYSIM SUBPROBLEMS=4 (673225599)

$TABLE ROW ID KA Q FILE=NMsim_xgxr021_subprobs_1.tab
$TABLE ID V2 V3 FORMAT=tF13.4 FILE=NMsim_xgxr021_subprobs_2.tab
$TABLE ID CL FIRSTONLY FORMAT=,1PE15.8 FILE=NMsim_xgxr021_subprobs_3.tab
$TABLE ROW ID KA Q FILE=NMsim_xgxr021_subprobs_1.tab
$TABLE ID V2 V3 FORMAT=tF13.4 FILE=NMsim_xgxr021_subprobs_2.tab
NOPRINT NOAPPEND ONEHEADER

