% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PTN_metrics.R
\name{PTN_metrics}
\alias{PTN_metrics}
\title{Calculate Node and Global Metrics for Trait Networks}
\usage{
PTN_metrics(graph)
}
\arguments{
\item{graph}{An igraph object representing the trait network, typically generated by the \code{PTN} function.}
}
\value{
A list containing two data frames:
\item{node}{A data frame with node-level metrics including degree, closeness, betweenness, and local clustering coefficient.}
\item{global}{A data frame with global metrics including edge density, diameter, average path length, average clustering coefficient, and modularity.}
}
\description{
This function computes various node and global metrics for a trait network graph.
}
\examples{
data(PFF)
rownames(PFF) <- PFF$species
PFF_traits <- PFF[, c("Height", "Leaf_area","LDMC","SLA","SRL","SeedMass","FltDate",
                      "FltDur","Leaf_Cmass","Leaf_Nmass","Leaf_CN","Leaf_Pmass",
                      "Leaf_NP","Leaf_CP","Root_Cmass","Root_Nmass","Root_CN")]
PFF_traits <- na.omit(PFF_traits)
head(PFF_traits)
ptn_result <- PTN(traits_matrix = PFF_traits, rThres = 0.2, pThres = 0.05)
PTN_metrics(ptn_result)

data(PFF_tree)
ptn_phylo_result <- PTN(traits_matrix = PFF_traits,
                      rThres = 0.2,
                      pThres = 0.05,
                      method = "pearson",
                      phylo_correction = TRUE,
                      phylo_tree = PFF_tree)
PTN_metrics(ptn_phylo_result)

}
\references{
\enumerate{
\item He, N., Li, Y., Liu, C., et al. (2020). Plant trait networks: improved resolution of the dimensionality of adaptation.
Trends in Ecology & Evolution, 35(10), 908-918.
\item Li, Y., Liu, C., Sack, L., Xu, L., Li, M., Zhang, J., & He, N. (2022). Leaf trait network architecture shifts with
species‐richness and climate across forests at continental scale. Ecology Letters, 25(6), 1442-1457.
}
}
