% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenerateQ.matrices.r
\name{get_lognormal_rates}
\alias{get_lognormal_rates}
\title{Get discrete log-normal rates}
\usage{
get_lognormal_rates(meanlog, sdlog, k)
}
\arguments{
\item{meanlog}{Numeric. Mean on the log scale.}

\item{sdlog}{Numeric. Standard deviation on the log scale.}

\item{k}{Integer. Number of rate categories.}
}
\value{
Numeric vector of length k representing the discrete log-normal rates.
}
\description{
Computes a set of discrete log-normal rates for rate variation across sites or characters.
The rates are normalized so that the mean rate equals 1.
}
\examples{
get_lognormal_rates(meanlog = 0, sdlog = 1, k = 4)
}
