% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{MoE_AvePP}
\alias{MoE_AvePP}
\title{Average posterior probabilities of a fitted MoEClust model}
\usage{
MoE_AvePP(x,
          group = TRUE)
}
\arguments{
\item{x}{An object of class \code{"MoEClust"} generated by \code{\link{MoE_clust}}, or an object of class \code{"MoECompare"} generated by \code{\link{MoE_compare}}. Models with gating and/or expert covariates and/or a noise component are facilitated here too.}

\item{group}{A logical indicating whether the average posterior probabilities should be computed \emph{per component}. Defaults to \code{TRUE}.}
}
\value{
When \code{group=TRUE}, a named vector of numbers, of length equal to the number of components (G), in the range [1/G,1], such that \emph{larger} values indicate clearer separation of the clusters. Note that \code{G=x$G} for models without a noise component and \code{G=x$G + 1} for models with a noise component. When \code{group=FALSE}, a single number in the same range is returned.
}
\description{
Calculates the per-component average posterior probabilities of a fitted MoEClust model.
}
\details{
When \code{group=TRUE}, this function calculates AvePP, the average posterior probabilities of membership for each component for the observations assigned to that component via MAP probabilities. Otherwise, an overall measure of clustering certainty is returned.
}
\note{
This function will always return values of \code{1} for all components for models fitted using the \code{"CEM"} algorithm (see \code{\link{MoE_control}}), or models with only one component.
}
\examples{
data(ais)
res <- MoE_clust(ais[,3:7], G=3, gating= ~ BMI + sex, 
                 modelNames="EEE", network.data=ais)

# Calculate the AvePP per component
MoE_AvePP(res)

# Calculate an overall measure of clustering certainty
MoE_AvePP(res, group=FALSE)
}
\references{
Murphy, K. and Murphy, T. B. (2020). Gaussian parsimonious clustering models with covariates and a noise component. \emph{Advances in Data Analysis and Classification}, 14(2): 293-325. <\doi{10.1007/s11634-019-00373-8}>.
}
\seealso{
\code{\link{MoE_clust}}, \code{\link{MoE_control}}, \code{\link{MoE_entropy}}
}
\author{
Keefe Murphy - <\email{keefe.murphy@mu.ie}>
}
\keyword{utility}
