% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_mixture_fit}
\alias{plot_mixture_fit}
\title{Plot mixture fit with individual components}
\usage{
plot_mixture_fit(
  data,
  estimated_params,
  bins = 200,
  plot_components = TRUE,
  save_path = NULL,
  show_plot = TRUE,
  title = "Mixture of Alpha-Stable Distributions"
)
}
\arguments{
\item{data}{Numeric vector of observations.}

\item{estimated_params}{List with weights, alphas, betas, gammas, deltas.}

\item{bins}{Number of histogram bins.}

\item{plot_components}{Logical, whether to show individual components.}

\item{save_path}{Optional PNG filename.}

\item{show_plot}{Logical, whether to display the plot.}

\item{title}{Plot title.}
}
\value{
Invisibly returns the file path to the saved plot (if \code{save_path} is provided), or \code{NULL} otherwise.
}
\description{
Displays the estimated mixture density and optionally its individual components
over a histogram of the data.
}
