% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CCA_algorithm.R
\name{DGP_OC}
\alias{DGP_OC}
\title{Data Generating Process (Omics Data versus Compositional data)}
\usage{
DGP_OC(seed = 10, n, p, q, sigma.nu, sigma.eps, omega_X, omega_Y)
}
\arguments{
\item{seed}{an integer for the initial seed.}

\item{n}{an integer representing the sample size.}

\item{p}{an integer representing the feature size of the omics dataset.}

\item{q}{an integer representing the feature size of the compositional dataset.}

\item{sigma.nu}{a numerial value representing the strength of correlation.}

\item{sigma.eps}{a numerical value representing the strength of noise.}

\item{omega_X}{a p vector representing the coefficient for the omics data.}

\item{omega_Y}{a q vector representing the coefficient for the compositional data.}
}
\value{
A list containing the following elements: (a) \code{Y}: a n*(2p) matrix representing the full observations; (b) \code{View.ind}: a 2p integer vector indicating the classes of features. The features with the same View.ind is in the same class; (c) \code{omega} a 2p vector representing the true coefficients.
}
\description{
Data Generating Process (Omics Data versus Compositional data)
}
\examples{
library(dplyr)
n <- 200
p <- q <- 100
sigma.nu <- 5
sigma.eps <- 1
omega_X <- 0.85*c(rep(1/10,9),-9/10,rep(0,p-10))
omega_Y <- 0.85*c(seq(0.08,0.12,length = 10),rep(0,q-10))
Data1 <- DGP_OC(seed=10,n,p,q,sigma.nu,sigma.eps,omega_X,omega_Y)
}
