\name{extract_Gamma_EReMI}
\alias{extract_Gamma_EReMI}
\title{
Extract Estimated Gamma Matrix for a Specific Cluster Combination
}
\description{
Extracts the estimated Gamma matrix corresponding to a specific (P, Q) cluster solution from the output of the E-ReMI algorithm.
}
\usage{
extract_Gamma_EReMI(x, selection)
}
\arguments{
  \item{x}{
An object returned by the \code{EReMI()} function, containing the list of estimated Gamma matrices for different cluster combinations.
}
  \item{selection}{
A character string or numeric vector specifying the cluster combination. 
If a character string, it should be in the form \code{"(P,Q)"}, e.g., \code{"(3,4)"}. 
If numeric, it will be internally converted to the appropriate label.
}
}
\details{
This function simplifies access to the estimated Gamma matrix for a user-specified combination of row (P) and column (Q) clusters, as identified in the output of the E-ReMI algorithm. 
It automatically reformats the input if the selection is provided in character form (e.g., \code{"(3,4)"}).
}
\value{
A matrix of estimated Gamma values corresponding to the specified cluster combination.

If the cluster combination is invalid or not found, \code{NULL} is returned.
}
\references{
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2025). Robustness study of normality-based likelihood ratio tests 
for testing maximal interaction two-mode clustering and a permutation-based alternative. \emph{Available on OSF} (submitted to ADAC).
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2023). E-ReMI: extended maximal interaction two-mode clustering. 
\emph{Journal of Classification, 40, 298-331.}
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2021). REMAXINT: a two-mode clustering-based method for statistical
inference on two-way interaction. \emph{Advances in Data Analysis and Classification, 15(4), 987-1013.}
}
\author{
Zaheer Ahmed (ahmed@ifado.de), 
Jan Schepers (jan.schepers@maastrichtuniversity.nl), 
Uwe Ligges (ligges@statistik.tu-dortmund.de), 
Alberto Cassese (alberto.cassese@unifi.it), 
Gerard van Breukelen (gerard.vbreukelen@maastrichtuniversity.nl),
Katja Ickstadt (ickstadt@statistik.tu-dortmund.de), 
Edmund Wascher (wascher@ifado.de) 
}
\note{
Used internally by visualization and post-processing functions for E-ReMI output.
}
\seealso{
\code{\link{E_ReMI}}, \code{\link{Permutation_Function}}, \code{\link{MaxInt_data_analysis}}, 
\code{\link{screeplot.MaxInt_data_analysis}}, \code{\link{MaxInteraction.plot}}
}
