% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-clustering.R
\name{.weight_kmeans}
\alias{.weight_kmeans}
\title{Compute Weights for K-means-Based Membership Assignment (Internal)}
\usage{
.weight_kmeans(clusters)
}
\arguments{
\item{clusters}{Integer vector containing the K-means cluster assignments for
each model. Values must be in \code{1:k}, where \code{k} is the number
of clusters.}
}
\value{
A numeric matrix of size \code{n × k} containing membership weights
derived from cluster frequencies. Row names are preserved if the input
vector has names.
}
\description{
For a cluster assignment vector \code{clusters}, the weight for model \code{i}
is defined as:

\deqn{ w_i = 1 / (\text{size of cluster assigned to } i) }

This results in:
\itemize{
\item Models in large clusters receive smaller weights.
\item Models in small clusters receive larger weights.
}

A membership matrix with dimensions \code{n × k} is produced, where:
\itemize{
\item \code{n}: number of models
\item \code{k}: number of clusters
}

For row \code{i} and cluster \code{clusters[i]}, the weight matrix entry
\code{[i, clusters[i]]} equals \code{w_i}. All other entries in row \code{i}
are zero.
}
\details{
This internal helper function converts hard K-means cluster assignments
into a simple weight matrix. Each element of the input vector
represents the cluster index assigned to a model. The function computes
weights based on cluster frequencies, assigning each model a weight
inversely proportional to the size of its cluster.

This function is intended to provide weights for Meta Fuzzy Function.
Unlike fuzzy methods, weights do not sum to 1 across each row;
they directly reflect inverse cluster frequencies.
}
\keyword{internal}
