% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/madtest.R
\name{madtest}
\alias{madtest}
\title{Hypothesis Test to Compare Two Median Absolute Deviations (MADs)}
\usage{
madtest(
  x,
  y,
  ratio = 1,
  conf.level = 0.95,
  use.squared = FALSE,
  use.gld = FALSE,
  gld.est = "TM",
  ...
)
}
\arguments{
\item{x, y}{numeric vectors of data values.}

\item{ratio}{a number representing the value of the ratio of the two MADs (or squared MADs) under the null hypothesis.}

\item{conf.level}{confidence level for the confidence interval.  The default is 0.95 (for a 95\% confidence interval).}

\item{use.squared}{a logical indicating whether the squared MADs should be used.  Default is \code{FALSE}.}

\item{use.gld}{a logical indicating whether the Generalised Lambda Distribution (GLD) should be used to estimate the density of the data.  Default is \code{FALSE} in which case the function \code{density()} is used for kernel density estimation.}

\item{gld.est}{a character string indicating which GLD estimator to use if \code{use.gld = TRUE}.  See details below.}

\item{...}{additional arguments, if desired, to be passed to function \code{density()} for density estimation (see help file for \code{\link[=density]{density()}} for more details).}
}
\value{
Hypothesis test results comparing two mads from independent samples and associated confidence interval for the ratio of mads (a list with class "htest").  This list includes values
\describe{
\item{\code{statistic}}{the value of the Z-statistic.}
\item{\code{p.value}}{the p-value for the test.}
\item{\code{conf.int}}{a confidence interval for the ratio of MADs (or squared MADs).}
\item{\code{estimate}}{the estimated ratio of MADs (or squared MADs).}
\item{\code{null.value}}{the specified hypothesized value of the ratio under the null hypothesis.}
\item{\code{alternative}}{a character string describing the alternative hypothesis.  Note, for this test only two-sided alternatives are allowed.}
\item{\code{data.name}}{a character string giving the names of the data.}
}
}
\description{
Performs hypothesis tests and calculates confidence intervals to compare MADs of two samples.
}
\details{
This function carries out hypothesis tests and calculates confidence intervals for comparing the MADs between two populations.
Two independent samples are required, and the intervals are constructed for the ratio of mads (or squared mads as an analog to ratio of variances) as described in Arachchige and Prendergast (2024).
The interval is first computed for the log of the ratio before being back-transformed to the ratio scale.  The hypothesis test is carried out in a similar way, based on the
log ratio and using asymptotic normality of the test statistic.  The default for the ratio under the null hypothesis is one which tests against equality of mads.
}
\examples{
# Create some data
set.seed(1234)
x <- rlnorm(100)
y <- rlnorm(50, meanlog = 0.5)

# Calculate the mad, 95\% confidence interval and test the hypothesis
mads.est <- madtest(x, y)
mads.est
}
\references{
Arachchige, C.N.P.G., & Prendergast, L.A. (2026) Confidence intervals for median absolute deviations. Communications in Statistics-Simulation and Computation, 55(1), 13-22.
}
