% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InsuranceParameters.R
\name{setCost}
\alias{setCost}
\title{Update one component of an \link{InsuranceTarif}'s cost structure}
\usage{
setCost(costs, type, basis = "SumInsured", frequency = "PolicyPeriod", value)
}
\arguments{
\item{costs}{The cost definition matrix (usually created by \code{\link[=initializeCosts]{initializeCosts()}})}

\item{type}{The cost type (alpha, Zillmer, beta, gamma, gamma_nopremiums, unitcosts)}

\item{basis}{The basis fo which the cost rate is applied (default is SumInsured)}

\item{frequency}{How often / during which period the cost is charged (once, PremiumPeriod, PremiumFree, PolicyPeriod, FullContract)}

\item{value}{The new cost value to set for the given type, basis and frequency}
}
\value{
The modified cost structure
}
\description{
Insurance tariff costs are defined by a cost matrix with dimensions: \{CostType, Basis, Period\}, where:
\describe{
\item{CostType:}{alpha, Zillmer, beta, gamma, gamma_nopremiums, unitcosts}
\item{Basis:}{SumInsured, SumPremiums, GrossPremium, NetPremium, Constant}
\item{Period:}{once, PremiumPeriod, PremiumFree, PolicyPeriod, AfterDeath, FullContract}
}
After creation (using the function \code{\link[=initializeCosts]{initializeCosts()}}), the funciton \code{setCost}
can be used to modify a single entry. While \code{\link[=initializeCosts]{initializeCosts()}} provides arguments
to set the most common types of cost parameters in one call, the \code{setCost}
function allows to modify any cost parameter.
}
\details{
This function modifies a copy of the cost structure and returns it, so this
function can be chained as often as desired and final return value will contain
all cost modifications.
}
\examples{
costs = initializeCosts()
setCost(costs, "alpha", "SumPremiums", "once", 0.05)

}
