% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_values.R
\name{model_values}
\alias{model_values}
\title{Construct a model and return the model values}
\usage{
model_values(data, tilde, family = c("linear", "prob", "counts"))
}
\arguments{
\item{data}{A data frame containing the training data. When used with \code{mutate()}, \code{data} will
hold the model specification, instead of \code{tilde}.}

\item{tilde}{A model specification in the form of a tilde expression}

\item{family}{The type of model architecture: \code{"linear"}, \code{"prob"}, or \code{"counts"}}
}
\value{
A \strong{vector} (not a data frame) of the model evaluated on the training data.
This is intended mainly for use within \code{mutate()}, so that a general model can be used in
the place of simple reduction verbs like \code{mean()}, \code{median()}
}
\description{
One-stop shopping to fit a model and return the model output on the training data.
}
\details{
This is intended to be used ONLY WITHIN \code{mutate()}
}
\examples{
mtcars |> mutate(mpg_mod = model_values(mpg ~ hp + wt)) |> select(hp, wt, mpg_mod) |> head()

}
