% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LST_terra.R
\name{E_Skokovic}
\alias{E_Skokovic}
\title{Land Surface Emissivity according to Skokovic et al. 2014}
\usage{
E_Skokovic(red = red, NDVI = NDVI, band = band)
}
\arguments{
\item{red}{SpatRaster object, red band of remote sensing imagery}

\item{NDVI}{SpatRaster object, NDVI calculated from remote sensing imagery}

\item{band}{A string specifying which Landsat 8 thermal band to use. It can be "band 10" or
"band 11"}
}
\value{
SpatRaster
}
\description{
This function calculates Land Surface Emissivity according to Skokovic et al. 2014
}
\examples{
red <- terra::rast(ncol=100, nrow=100)
set.seed(2)
terra::values(red) = runif(10000, min=0.1, max=0.4)
NDVI <- terra::rast(ncol=100, nrow=100)
set.seed(2)
terra::values(NDVI) = runif(10000, min=0.02, max=0.8)
E_Skokovic(red = red, NDVI = NDVI, band = "band 11")
}
\references{
Skoković, D., Sobrino, J.A., Jimenez-Munoz, J.C., Soria, G., Julien, Y., Mattar, C. and Cristóbal, J., 2014. Calibration and Validation of land surface temperature for Landsat8-TIRS sensor. Land product validation and evolution.
}
