% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_custom_agent.R
\name{compile_graph}
\alias{compile_graph}
\title{Compile a Custom Agent Graph (LangGraph-Style Output)}
\usage{
compile_graph(
  node_functions,
  entry_point,
  edges = list(),
  conditional_edges = list(),
  default_state = list(),
  checkpointer = NULL,
  direction = c("TD", "LR"),
  subgraphs = NULL,
  style = TRUE
)
}
\arguments{
\item{node_functions}{Named list of node functions. Each function takes `state`
and returns a named list or [make_command()].}

\item{entry_point}{Name of the start node (must exist in `node_functions`).}

\item{edges}{Optional list of static edges. Each item can be:
- a character vector of length 2: `c("from", "to")`, or
- a list with `from` and `to`.}

\item{conditional_edges}{Optional list where each item contains:
- `from` (or `node_name`),
- `condition` (or `condition_fun`),
- `mapping` (or `mapping_list`) as a named list of label -> node.}

\item{default_state}{Optional named list merged into `state` for missing keys.}

\item{checkpointer}{Optional callback `function(state, current_node)` executed
after each transition.}

\item{direction}{Mermaid direction used when `output` includes Mermaid.}

\item{subgraphs}{Optional named list of subgraph groups for Mermaid rendering.}

\item{style}{Logical; include default Mermaid class styling.}
}
\value{
A list with `run`, `graph`, and `mermaid`.
}
\description{
Convenience wrapper around [build_custom_agent()] that returns both runnable
agent and Mermaid graph artifacts.
}
