% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lopez_ruzicka.R
\name{lopez_ruzicka}
\alias{lopez_ruzicka}
\title{Lopez-Ruzicka decomposition}
\usage{
lopez_ruzicka(
  mx1,
  mx2,
  age = (1:length(mx1)) - 1,
  nx = rep(1, length(mx1)),
  sex1 = "t",
  sex2 = sex1,
  closeout = TRUE
)
}
\arguments{
\item{mx1}{numeric vector of the mortality rates (central death rates) for population 1}

\item{mx2}{numeric vector of the mortality rates (central death rates) for population 2}

\item{age}{integer vector of the lower bound of each age group (currently only single ages supported)}

\item{nx}{integer vector of age intervals, default 1.}

\item{sex1}{character either the sex for population 1: Male (\code{"m"}), Female (\code{"f"}), or Total (\code{"t"})}

\item{sex2}{character either the sex for population 2: Male (\code{"m"}), Female (\code{"f"}), or Total (\code{"t"}) assumed same as \code{sex1} unless otherwise specified.}

\item{closeout}{logical. Default \code{TRUE}. Shall we use the HMD Method Protocol to close out the \code{ax} and \code{qx} values? See details.}
}
\value{
Numeric vector of contributions by age group that sum to the total difference
in life expectancy between the two mortality schedules.
}
\description{
Implements the decomposition of life expectancy proposed by Lopez and Ruzicka, as described in Ponnapalli (2005). This method expresses the difference in life expectancy between two mortality schedules in terms of an exclusive effect and an interaction effect, using life table quantities.

Let \eqn{e_x^i} denote remaining life expectancy at age \eqn{x} for population \eqn{i}, and \eqn{l_x^i} the number of survivors to age \eqn{x}. Then:
\itemize{
\item \strong{Exclusive effect}:
\deqn{
\frac{l_x^1}{l_x^2} \left[ l_x^2 (e_x^2 - e_x^1) - l_{x+n}^2 (e_{x+n}^2 - e_{x+n}^1) \right]
}
\item \strong{Interaction effect}:
\deqn{
(e_{x+n}^2 - e_{x+n}^1) \cdot \left[
\frac{l_x^1 \cdot l_{x+n}^2}{l_x^2} - l_{x+n}^1
\right]
}
}

The total contribution to life expectancy difference in age group \eqn{x} is the sum of the exclusive and interaction effects.
}
\details{
This method produces \strong{numerically identical results} to \code{arriaga()}.
}
\examples{
a <- 0.001
b <- 0.07
x <- 0:100
mx1 <- a * exp(x * b)
mx2 <- a/2 * exp(x * b)
cc <- lopez_ruzicka(mx1, mx2, age = x)
sum(cc)
}
\references{
\insertRef{Ponnapalli2005}{LEdecomp}
}
\seealso{
\code{\link{arriaga}}, \code{\link{chandrasekaran_III}}, \code{\link{lopez_ruzicka_sym}}
}
