% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpfunctions_formulas.R
\name{extract_lhs_varnames}
\alias{extract_lhs_varnames}
\title{Extract variable names from the left-hand side of a formula}
\usage{
extract_lhs_varnames(formula)
}
\arguments{
\item{formula}{A formula object, a list of formulas, or \code{NULL}.}
}
\value{
A character vector of variable names from the LHS of the formula,
or a list of such vectors if a list of formulas is provided.
Returns \code{NULL} if the input is \code{NULL}.
}
\description{
This internal helper function extracts variable names from the left-hand
side (LHS) of a formula or a list of formulas. It supports standard formulas,
survival objects, transformations (e.g., \code{log(x)}), and multivariate outcomes
(e.g., \code{cbind(a, b, c)}).
}
\seealso{
\code{\link[=extract_lhs_string]{extract_lhs_string()}}
}
\keyword{internal}
