% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpfunctions_checks.R
\name{convert_variables}
\alias{convert_variables}
\title{Convert variables}
\usage{
convert_variables(data, allvars, mess = TRUE)
}
\arguments{
\item{data}{a \code{data.frame}}

\item{allvars}{a character vector of the relevant variables in \code{data}}

\item{mess}{logical, if \code{TRUE} messages are printed}
}
\value{
the cleaned \code{data.frame}
}
\description{
Cleans up the data by
\itemize{
\item changing \code{NaN} to \code{NA}
\item converting continuous variables with just two values to factor
\item converting logical variables to a factor
\item cleaning factor labels (using \code{make.names()})
}
}
\details{
used in model_imp (2025-09-07)
}
\keyword{internal}
