% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_misc.R
\name{compute_rsquared}
\alias{compute_rsquared}
\title{Compute Bayesian R-squared from matrix of posterior replications}
\usage{
compute_rsquared(yrep)
}
\arguments{
\item{yrep}{Matrix with rows representing samples and columns representing observations}
}
\value{
Bayesian R-squared (scalar, between 0 and 1)
}
\description{
The function returns a global estimate rather than an estimate for each sample,
since the predictive means and residual variance are estimated from replications
instead of being computed on a per-sample basis.
}
\examples{
N <- 50
N_sample <- 1e2
y <- runif(N, 0, 10)
yrep <- do.call(
  cbind,
  lapply(
    1:N,
    function(i) {
      y[i] + rnorm(N_sample)
    }
  )
)
compute_rsquared(yrep)
}
\references{
Gelman, A. et al. (2019) "R-squared for Bayesian Regression Models",
The American Statistician, 73(3), pp. 307–309. \doi{doi:10.1080/00031305.2018.1549100}.
}
