% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HNPclassifier.r
\name{base_function}
\alias{base_function}
\title{Base Classifier Training function
Train a base multi-class model (RF / SVM / Multinomial Logistic)}
\usage{
base_function(x, y, method = "randomforest")
}
\arguments{
\item{x}{A data.frame of predictors/features.}

\item{y}{A factor response with levels "1","2","3".}

\item{method}{Character string: one of 'randomforest', 'svm', or 'logistic'.}
}
\value{
A trained model object compatible with the downstream scoring
functions.
}
\description{
Fit one of the supported classifiers for ternary classification:
Random Forest, SVM (with probabilities), or multinomial logistic regression
via \code{nnet::multinom}.
}
\examples{
set.seed(123)
x <- data.frame(a = rnorm(20), b = rnorm(20))
y <- factor(sample(c("1","2","3"), 20, TRUE))
model <- base_function(x, y, method = 'randomforest')
}
