% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rerandomization_search.R
\name{initRerandomizationExperimentalDesignObject}
\alias{initRerandomizationExperimentalDesignObject}
\title{Begin a Rerandomization Search}
\usage{
initRerandomizationExperimentalDesignObject(
  X = NULL,
  obj_val_cutoff_to_include,
  max_designs = 1000,
  objective = "mahal_dist",
  Kgram = NULL,
  wait = FALSE,
  start = TRUE,
  num_cores = 1,
  seed = NULL,
  verbose = TRUE,
  use_safe_inverse = FALSE
)
}
\arguments{
\item{X}{The design matrix with $n$ rows (one for each subject) and $p$ columns 
(one for each measurement on the subject). This is the design matrix you wish 
to search for a more optimal design.}

\item{obj_val_cutoff_to_include}{Only allocation vectors with objective values lower than this threshold will be returned.
If the cutoff is infinity, you are doing BCRD and you should use the \code{complete_randomization_with_forced_balanced}
function instead.}

\item{max_designs}{The maximum number of designs to be returned. Default is 10,000. Make this large 
so you can search however long you wish as the search can be stopped at any time by
using the \code{\link{stopSearch}} method}

\item{objective}{The objective function to use when searching design space. This is a string
with valid values "\code{mahal_dist}" (the default), "\code{abs_sum_diff}" or "\code{kernel}".}

\item{Kgram}{If the \code{objective = kernel}, this argument is required to be an \code{n x n} matrix whose
entries are the evaluation of the kernel function between subject i and subject j. Default is \code{NULL}.}

\item{wait}{Should the \code{R} terminal hang until all \code{max_designs} vectors are found? The 
default is \code{FALSE}.}

\item{start}{Should we start searching immediately (default is \code{TRUE}).}

\item{num_cores}{The number of CPU cores you wish to use during the search. The default is \code{1}.}

\item{seed}{The set to set for deterministic output. This should only be set if \code{num_cores = 1} otherwise
the output will not be deterministic. Default is \code{NULL} for no seed set.}

\item{verbose}{Should the algorithm emit progress output? Default is \code{TRUE}.}

\item{use_safe_inverse}{Should a regularized inverse be used for the Mahalanobis objective?
Default is \code{FALSE}.}
}
\value{
An object of type \code{rerandomization_experimental_design_search} which can be further operated upon.
}
\description{
This method creates an object of type rerandomization_experimental_design and will immediately initiate
a search through allocation space for forced-balance designs. For debugging, you can use set the \code{seed}
parameter and \code{num_cores = 1} to be assured of deterministic output.
}
\examples{
\dontrun{
set.seed(1)
X = matrix(rnorm(20), nrow = 10)
obj = initRerandomizationExperimentalDesignObject(
  X,
  max_designs = 5,
  num_cores = 1,
  objective = "abs_sum_diff",
  obj_val_cutoff_to_include = Inf,
  start = TRUE,
  wait = TRUE,
  verbose = FALSE
)
obj
}
}
\author{
Adam Kapelner
}
