% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FA.R
\name{FA}
\alias{FA}
\title{Factor Analysis}
\usage{
FA(X, r)
}
\arguments{
\item{X}{The observation data matrix of dimension \eqn{T \times N}.}

\item{r}{The number of factors to estimate.}
}
\value{
A list containing:
\item{F}{The estimated factors matrix of dimension \eqn{T \times r}.}
\item{L}{The estimated factor loadings matrix of dimension \eqn{N \times r}.}
}
\description{
Performs Factor Analysis using Principal Component Analysis (PCA) to extract factors and loadings.
}
\examples{
X <- matrix(rnorm(100*20), 100, 20)
res <- FA(X, r = 2)
head(res$F)
head(res$L)

}
\references{
Bai, J., & Ng, S. (2002). Determining the number of factors in approximate factor models. Econometrica, 70(1), 191-221.
}
\author{
Jiaqi Hu
}
