% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repeated_measures_test.R
\name{repeated_measures_test}
\alias{repeated_measures_test}
\title{Perform test on two repeated measures}
\usage{
repeated_measures_test(T1, T2, rnames = TRUE, shrink = FALSE)
}
\arguments{
\item{T1, T2}{matrices (n x p of n observation for p variables)
or arrays (t x p x n of n observations, t landmarks in p
dimensions),}

\item{rnames}{if TRUE (default) the rownames of the matrix or the
names along the 3rd dimension (for arrays) will be used to match
the order}

\item{shrink}{if TRUE, a shrinkage estimator of covariance is used
internally}
}
\value{
The function outputs a matrix n x p of the original data
  projected to the subspace orthogonal to the vector
}
\description{
Test based on Hotelling's T squared for the null hypothesis of
no effect between two repeated measures (e.g., treatment/control)
}
\details{
The function assumes that each individual observation (e.g.,
specimen) has been measured two times (e.g., at two time points,
or between two treatments).

If rnames is TRUE (default), the rownames of the matrix or the
names along the 3rd dimension (for arrays) will be used to match
the order of observations (e.g., specimens) between the two
datasets. Otherwise, the function will assume that the
observations in T1 and T2 are in the same order.

This function is useful in various contexts, such as:
 \itemize{
  \item testing the effect of preservation (Fruciano et al. 2020)
  \item testing for variation through time
}

For instance, in the context of the effect of preservation on
geometric morphometrics, it has been argued (Fruciano, 2016) that
various studies have improperly used on repeated measures data
methods developed for independent observations, and this can lead
to incorrect inference.
}
\section{Notice}{

The function requires internally non-singular matrices
(for instance, number of cases should be larger than the number
of variables).
One solution can be to perform a principal component analysis and
use the scores for all the axes with non-zero and non-near-zero
eigenvalues.
To overcome some situations where a singular matrix can occurr,
the function can use internally a shrinkage estimator of the
covariance matrix (Ledoit & Wolf 2004).
This is called setting shrink = TRUE.
However, in this case, the package nlshrink should have been
installed.
Also, notice that if the matrices T1 and T2 are provided as
arrays, this requires the package Morpho to be installed.
}

\section{Citation}{

If you use this function please cite Fruciano et al. 2020
}

\references{
Fruciano C. 2016. Measurement error in geometric
morphometrics. Development Genes and Evolution 226:139-158.

Fruciano C., Schmidt, I., Ramirez Sanchez, M.M.,
Morek, W., Avila Valle, Z.A., Talijancic, I., Pecoraro, C.,
Schermann Legionnet, A. 2020. Tissue preservation can affect
geometric morphometric analyses: a case study using fish body
shape. Zoological Journal of the Linnean Society 188:148-162.

Ledoit O, Wolf M. 2004. A well-conditioned estimator
for large-dimensional covariance matrices. Journal of Multivariate
Analysis 88:365-411.
}
