% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof_stat.R
\name{gof_stat}
\alias{gof_stat}
\title{Function to estimate quantiles for a goodness-of-fit test for generalized Ornstein-Uhlenbeck process}
\usage{
gof_stat(X, T1, N, p, q)
}
\arguments{
\item{X}{observations}

\item{T1}{last time of observation}

\item{N}{number of observations on from on interval (0,T1]}

\item{p}{number of cosine coefficients >=1}

\item{q}{number of sine coefficients >=0}
}
\value{
\item{out}{List of statistics (cvm and ks), estimated parameters, and pseudo-observations}
}
\description{
Function to calculate the quantiles of Cramer-von Mise and Kolmogorov-Smirnov statistics.
}
\examples{
T1=20
N=500
data(X)
out = gof_stat(X,T1,N,2,0)
}
