% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vallet_vta.r
\name{vallet_vta}
\alias{vallet_vta}
\title{Calculate Total Aboveground Volume (VTA) Vallet Method}
\usage{
vallet_vta(data, na_action = c("error", "omit"), output = NULL)
}
\arguments{
\item{data}{A data frame containing tree measurements. Must include the columns:
\code{species_code} (in uppercase Latin format), \code{c130} (circumference at 1.30m, in cm),
and \code{htot} (total height, in m).}

\item{na_action}{How to handle missing input values. \code{"error"} (default) stops if
core required values are explicitly \code{NA}. \code{"omit"} removes rows with missing core data.
Note: Model constraint violation (\code{c130} < 45 cm) and unknown species are always
handled by setting VTA and Form Factor to NA, preserving input values.}

\item{output}{Optional file path (string). If provided, the resulting data frame
will be written to this file using semicolon (;) as a delimiter. NA values are
written as empty strings (""). Defaults to \code{NULL}.}
}
\value{
The resulting data frame (same as the printed data) with the new columns and \code{vallet_vta} (Total Aboveground Volume in \strong{m3})..
}
\description{
Computes the total aboveground volume (VTA) for trees based on
the circumference at 1.30m (c130) and total height (htot) using the
Vallet form factor method.
}
\details{
The model is only valid for trees with a circumference at 1.30m (\code{c130}) of at least 45 cm.
For non-compliant trees or unknown species, results are set to \code{NA}.

The Form Factor (\code{form}) is calculated as:
\deqn{form = (a + b \cdot c_{130} + c \cdot \frac{\sqrt{c_{130}}}{h_{tot}}) \cdot \left(1 + \frac{d}{c_{130}^2}\right)}

The Total Aboveground Volume (\code{VTA}) is then:
\deqn{VTA = form \cdot \frac{1}{\pi \cdot 40000} \cdot c_{130}^2 \cdot h_{tot}}

Coefficients a, b, c, d are loaded from the \code{vallet_vta.csv} file.
}
\section{Supported species}{

The Vallet VTA method is currently implemented for the following species
(via their \code{species_code}):
\itemize{
\item \code{"PICEA_ABIES"}
\item \code{"QUERCUS_ROBUR"}
\item \code{"FAGUS_SYLVATICA"}
\item \code{"PINUS_SYLVESTRIS"}
\item \code{"PINUS_PINASTER"}
\item \code{"ABIES_ALBA"}
\item \code{"PSEUDOTSUGA_MENZIESII"}
}
}

\examples{
data_test <- data.frame(
  species_code = c("PICEA_ABIES", "FAGUS_SYLVATICA", "UNKNOWN_SPECIES", "QUERCUS_ROBUR"),
  c130 = c(60, 80, 50, 40), 
  htot = c(25, 18, 20, 22)
)

results_console <- vallet_vta(data_test)

}
