% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rondeux_vc22_vtot.R
\name{rondeux_vc22_vtot}
\alias{rondeux_vc22_vtot}
\title{Calculate Total and Commercial Stem Volume (Rondeux, larch)}
\usage{
rondeux_vc22_vtot(data, na_action = c("error", "omit"), output = NULL)
}
\arguments{
\item{data}{A data frame containing tree measurements. Must include:
\code{species_code} (uppercase character),
\code{c130} (circumference at 1.30 m, in cm),
\code{htot} (total height, in m).}

\item{na_action}{How to handle missing essential values (\code{c130}, \code{htot}).
\code{"error"} (default) stops if missing values are detected.
\code{"omit"} removes rows with missing essential fields.}

\item{output}{Optional file path where the resulting data frame should be
exported as a CSV. If NULL (default), no file is written.
Export is handled by the utility function \code{export_output()} and
failures trigger warnings without interrupting execution.}
}
\value{
A data frame identical to \code{data}, with two added columns:
\itemize{
\item \code{rondeux_vtot}: total stem volume (m3)
\item \code{rondeux_vc22}: commercial stem volume at 22 cm (m3)
}
}
\description{
Computes the total stem volume (\code{rondeux_vtot}) and the commercial
stem volume at 22 cm (\code{rondeux_vc22}) for larch trees according to
Rondeux equations, based on the circumference at 1.30 m (\code{c130}, in cm)
and the total height (\code{htot}, in meters).
}
\details{
The implemented equations are:

\deqn{v_{\mathrm{tot}} = a_{\mathrm{vtot}} \cdot c_{130}^2 \cdot h_{\mathrm{tot}}}
where \eqn{a_{\mathrm{vtot}} = 0.406780 \times 10^{-5}}.

\deqn{v_{c22} = a_{\mathrm{vc22}} + b_{\mathrm{vc22}} \cdot c_{130}^2 \cdot h_{\mathrm{tot}}}
where \eqn{a_{\mathrm{vc22}} = -0.008877} and
\eqn{b_{\mathrm{vc22}} = 0.412411 \times 10^{-5}}.

Expected units:
\itemize{
\item \code{c130}: cm
\item \code{htot}: m
\item output volumes: m3
}

These equations are valid \strong{only for larch}. Rows with other species are
returned with \code{NA} volumes and a warning is issued.
}
\examples{
df <- data.frame(
  species_code = c("LARIX_DECIDUA", "LARIX_DECIDUA", "LARIX_DECIDUA"),
  c130 = c(60, 65, 55),
  htot = c(15, 18, 20)
)

rondeux_vc22_vtot(df)

}
