% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FMAT.R
\name{weight_decay}
\alias{weight_decay}
\title{Compute a vector of weights with a decay rate.}
\usage{
weight_decay(vector, decay)
}
\arguments{
\item{vector}{Vector of sequence.}

\item{decay}{Decay factor for computing weights. A smaller decay value would give greater weight to the former items than to the latter items. The i-th item has raw weight = decay ^ i.
\itemize{
\item decay = 1: all items are \strong{equally} important
\item 0 < decay < 1: \strong{first} items are more important
\item decay > 1: \strong{last} items are more important
}}
}
\value{
\emph{Normalized} weights (i.e., sum of weights = 1).
}
\description{
Compute a vector of weights with a decay rate.
}
\examples{
# "individualism"
weight_decay(c("individual", "##ism"), 0.5)
weight_decay(c("individual", "##ism"), 0.8)
weight_decay(c("individual", "##ism"), 1)
weight_decay(c("individual", "##ism"), 2)

# "East Asian people"
weight_decay(c("East", "Asian", "people"), 0.5)
weight_decay(c("East", "Asian", "people"), 0.8)
weight_decay(c("East", "Asian", "people"), 1)
weight_decay(c("East", "Asian", "people"), 2)

}
\seealso{
\code{\link[=FMAT_run]{FMAT_run()}}
}
