% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FMAT.R
\name{FMAT_run}
\alias{FMAT_run}
\title{Run the fill-mask pipeline on multiple models (CPU / GPU).}
\usage{
FMAT_run(
  models,
  data,
  gpu,
  add.tokens = FALSE,
  add.verbose = FALSE,
  weight.decay = 1,
  pattern.special = special_case(),
  file = NULL,
  progress = TRUE,
  warning = TRUE,
  na.out = TRUE
)
}
\arguments{
\item{models}{A character vector of model names at
\href{https://huggingface.co/models}{HuggingFace}.}

\item{data}{A data.table returned from \code{\link[=FMAT_query]{FMAT_query()}} or \code{\link[=FMAT_query_bind]{FMAT_query_bind()}}.}

\item{gpu}{Use GPU (3x faster than CPU) to run the fill-mask pipeline? Defaults to missing value that will \emph{automatically} use available GPU (if not available, then use CPU). An NVIDIA GPU device (e.g., GeForce RTX Series) is required to use GPU. See \href{https://psychbruce.github.io/FMAT/#guidance-for-gpu-acceleration}{Guidance for GPU Acceleration}.

Options passing on to the \code{device} parameter in Python:
\itemize{
\item \code{FALSE}: CPU (\code{device = -1}).
\item \code{TRUE}: GPU (\code{device = 0}).
\item Others: passing on to \href{https://huggingface.co/docs/transformers/main_classes/pipelines#transformers.pipeline.device}{\code{transformers.pipeline(device=...)}} which defines the device (e.g., \code{"cpu"}, \code{"cuda:0"}, or a GPU device id like \code{1}) on which the pipeline will be allocated.
}}

\item{add.tokens}{Add new tokens (for out-of-vocabulary words or phrases) to model vocabulary? Defaults to \code{FALSE}.
\itemize{
\item Default method of producing the new token embeddings is computing the (equally weighted) average subword token embeddings. To change the weights of different subwords, specify \code{weight.decay}.
\item It just adds tokens temporarily without changing the raw model file.
}}

\item{add.verbose}{Print subwords of each new token? Defaults to \code{FALSE}.}

\item{weight.decay}{Decay factor of relative importance of multiple subwords. Defaults to \code{1} (see \code{\link[=weight_decay]{weight_decay()}} for computational details). A smaller decay value would give greater weight to the former subwords than to the latter subwords. The i-th subword has raw weight = decay ^ i.
\itemize{
\item decay = 1: all subwords are \strong{equally} important (default)
\item 0 < decay < 1: \strong{first} subwords are more important
\item decay > 1: \strong{last} subwords are more important
}

For example, decay = 0.5 would give 0.5 and 0.25 (with normalized weights 0.667 and 0.333) to two subwords (e.g., "individualism" = 0.667 "individual" + 0.333 "##ism").}

\item{pattern.special}{See \code{\link[=special_case]{special_case()}} for details.}

\item{file}{File name of \code{.RData} to save the returned data.}

\item{progress}{Show a progress bar? Defaults to \code{TRUE}.}

\item{warning}{Alert warning of out-of-vocabulary word(s)? Defaults to \code{TRUE}.}

\item{na.out}{Replace probabilities of out-of-vocabulary word(s) with \code{NA}? Defaults to \code{TRUE}.}
}
\value{
A data.table (class \code{fmat}) appending \code{data} with these new variables:
\itemize{
\item \code{model}: model name.
\item \code{output}: complete sentence output with unmasked token.
\item \code{token}: actual token to be filled in the blank mask
(a note "out-of-vocabulary" will be added
if the original word is not found in the model vocabulary).
\item \code{prob}: (raw) conditional probability of the unmasked token given the provided context, estimated by the masked language model.
\itemize{
\item Raw probabilities should \emph{NOT} be directly used or interpreted. Please use \code{\link[=summary.fmat]{summary.fmat()}} to \emph{contrast} between a pair of probabilities.
}
}
}
\description{
Run the fill-mask pipeline on multiple models with CPU or GPU (faster but requires an NVIDIA GPU device).
}
\details{
The function automatically adjusts for the compatibility of tokens used in certain models: (1) for uncased models (e.g., ALBERT), it turns tokens to lowercase; (2) for models that use \verb{<mask>} rather than \verb{[MASK]}, it automatically uses the corrected mask token; (3) for models that require a prefix to estimate whole words than subwords (e.g., ALBERT, RoBERTa), it adds a white space before each mask option word. See \code{\link[=special_case]{special_case()}} for details.

These changes only affect the \code{token} variable in the returned data, but will not affect the \code{M_word} variable. Thus, users may analyze data based on the unchanged \code{M_word} rather than the \code{token}.

Note also that there may be extremely trivial differences (after 5~6 significant digits) in the raw probability estimates between using CPU and GPU, but these differences would have little impact on main results.
}
\examples{
## Running the examples requires the models downloaded

\dontrun{
models = c("bert-base-uncased", "bert-base-cased")

query1 = FMAT_query(
  c("[MASK] is {TARGET}.", "[MASK] works as {TARGET}."),
  MASK = .(Male="He", Female="She"),
  TARGET = .(Occupation=c("a doctor", "a nurse", "an artist"))
)
data1 = FMAT_run(models, query1)
summary(data1, target.pair=FALSE)

query2 = FMAT_query(
  "The [MASK] {ATTRIB}.",
  MASK = .(Male=c("man", "boy"),
           Female=c("woman", "girl")),
  ATTRIB = .(Masc=c("is masculine", "has a masculine personality"),
             Femi=c("is feminine", "has a feminine personality"))
)
data2 = FMAT_run(models, query2)
summary(data2, mask.pair=FALSE)
summary(data2)
}

}
\seealso{
\code{\link[=set_cache_folder]{set_cache_folder()}}

\code{\link[=BERT_download]{BERT_download()}}

\code{\link[=BERT_vocab]{BERT_vocab()}}

\code{\link[=FMAT_query]{FMAT_query()}}

\code{\link[=FMAT_query_bind]{FMAT_query_bind()}}

\code{\link[=summary.fmat]{summary.fmat()}}

\code{\link[=special_case]{special_case()}}

\code{\link[=weight_decay]{weight_decay()}}
}
