% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance.R
\name{label_trans}
\alias{label_trans}
\title{Label transfer via k-NN (hard assignment)}
\usage{
label_trans(
  integrated,
  ref = "10X",
  query = "SS2",
  label_key = "annotation",
  emb_key = "pca",
  batch_key = "dataset",
  k = 10,
  seed = NULL
)
}
\arguments{
\item{integrated}{\link[Seurat]{Seurat} object with integrated PCA and
meta-data columns \code{dataset} and \code{annotation}.}

\item{ref}{Character string identifying the reference dataset (default
\code{"10X"}).}

\item{query}{Character string identifying the query dataset (default
\code{"SS2"}).}

\item{label_key}{Name of the meta-data column that indicates celltype}

\item{emb_key}{Name of the reduction to use (default \code{"pca"}).}

\item{batch_key}{Name of the meta-data column that indicates dataset/batch}

\item{k}{Number of nearest neighbours to vote (default 10).}

\item{seed}{Integer, random seed for reproducibility (optional). If NULL, uses current random state.}
}
\value{
Named character vector: predicted label for each query cell (names are
cell barcodes).
}
\description{
For every query cell, find its \code{k} nearest reference cells in the
integrated PCA space and assign the most frequent label among them.
}
