% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{gen_df_human}
\alias{gen_df_human}
\title{Generate a Simulated Dataset of Human Behavioral States Over 24 Hours}
\usage{
gen_df_human(n_individuals = 100, hours = c(0:23), prob_use = 0.5)
}
\arguments{
\item{n_individuals}{Integer. Number of individuals to simulate. Default is 100.}

\item{hours}{Integer vector. The hours of the day to simulate, typically \code{0:23}. Default is \code{0:23}.}

\item{prob_use}{Numeric. Probability of being a bednet user vs non-user. Default is 0.5.}
}
\value{
A data.frame with the following columns:
\describe{
\item{individual}{Individual ID.}
\item{hour}{Hour of the day (0–23).}
\item{bednet_user}{Logical, indicating whether the individual is a bednet user.}
\item{state}{Integer representing the individual’s state at that hour:
\code{1} = outdoors, \code{2} = indoors and awake, \code{3} = indoors asleep (non-user), \code{4} = indoors asleep under bednet (user).}
\item{state_label}{Factor version of \code{state} with descriptive labels.}
}
}
\description{
Simulates the hourly state of a set of individuals (either bednet users or non-users) over a 24-hour period.
Each individual's state is assigned probabilistically based on the hour of the day and whether they use a bednet.
}
\examples{
df <- gen_df_human(n_individuals = 50)
df <- gen_df_human(n_individuals = 100, hours = c(0:9,17:23))
head(df)

}
