% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.ElectDecomp}
\alias{plot.ElectDecomp}
\title{Graphical representation of ElectDecomp objects}
\usage{
\method{plot}{ElectDecomp}(
  x,
  type = "decomposition",
  panels.size = "global",
  title.size = 12,
  axis.title.size = 12,
  summaries = "RI",
  bar.width = 0.2,
  bar.color = "skyblue",
  text.color = "black",
  text.size = 3,
  labels.size = 10,
  ticks.linewidth = 0.2,
  length.breaks = 0.02,
  labels.y.size = 9,
  labels.x.size,
  parties,
  party.names,
  panels.title,
  axis.title,
  ...,
  show.plot = TRUE
)
}
\arguments{
\item{x}{An object output of either the \code{distortion} or \code{inequality} functions of the ElectDecomp package.}

\item{type}{When \code{x} is an output of \code{distortion}, this argument informs the output to be plotted. If \code{type = "districts"}, the method plots the \code{district2party.contributions} matrix; otherwise it plots the decomposition of the total deviation available in the \code{party.distortions} matrix.}

\item{panels.size}{When plotting an output of \code{distortion}, this argument informs about how the widths of panels should be calculated: either considering the deviations of all the parties ("global") or only the deviations of the plotted parties ("local"). Default, \code{"global"}.}

\item{title.size}{Size of the text of the panel titles. Default, 12.}

\item{axis.title.size}{Size of the text of the axis titles. Default, 12.}

\item{summaries}{This argument Informs whether some summary statistics about the election should be included in the plot: "none", no summary is included; "all" RI and \code{other.statistics} are included; "RI", only the representational inequality (RI) index is included. Default, "RI". Only active when an output of the \code{inequality} function is to be plotted.}

\item{bar.width}{Width of the bars or of the inequality curve. Default, 0.2.}

\item{bar.color}{Color of the bars or of the inequality curve. Default, "skyblue".}

\item{text.color}{Color to be used for text inside the plot. Default, "black".}

\item{text.size}{Size to be used for text inside the plot. Default, 3.}

\item{labels.size}{Size to be used for the labels of the axis. Default, 10.}

\item{ticks.linewidth}{Width of the lines to be used as ticks. Default, 0.2. Only active when the \code{party.distortions} matrix output of the \code{distortion} function is to be plotted.}

\item{length.breaks}{Distance between labels of the breaks x-axis. Default, 0.02. Only active when the \code{party.distortions} matrix output of the \code{distortion} function is to be plotted.}

\item{labels.y.size}{Size to be used for the labels of the y axis when \code{type = "districts"}. Default, 9.}

\item{labels.x.size}{Size to be used for the labels of the x axis when \code{type = "districts"}. If missing it is determined as a function of the number of parties to be plotted.}

\item{parties}{A vector with the indexes of the parties (columns) to be plotted. If missing, the six parties with the highest support in the election are chosen. Only active when an output of the \code{distortion} function is to be plotted.}

\item{party.names}{A vector with the names of the parties. If missing, names of the parties are inferred from the names of the columns to be plotted. Only active when an output of the \code{distortion} function is to be plotted.}

\item{panels.title}{A vector of length seven (for outputs of \code{distortion}) or of length one (for outputs of \code{inequality}) with the titles of the panels. If missing, they are automatically assigned taking into account the plotted component in each panel.}

\item{axis.title}{A vector of length two with the titles of the axis. If missing, they are automatically assigned taking into account the variable plotted in each axis.}

\item{...}{Other arguments passed on to methods.}

\item{show.plot}{A \code{TRUE/FALSE} argument indicating if the plot should be displayed as a side-effect. By default, \code{TRUE}.}
}
\value{
Invisibly returns the (ggplot) description of the plot, which is a list with components that contain the plot itself, the data, information about the scales, panels, etc.
}
\description{
Plot method for objects obtained with the functions \code{distortion} and \code{inequality} of the ElectDecomp package.
}
\note{
The packages \code{ggplot2} and \code{gridExtra} need to be installed for this function to work.
}
\examples{
votes.ex <- structure(list(UCD = c(92019L, 112927L, 117482L, 152498L, 89494L,
                                   103697L, 115390L, 223252L, 55837L, 46820L,
                                   138575L, 177843L, 163536L, 187254L, 140237L,
                                   102719L, 64603L, 102362L, 70550L, 39321L,
                                   101891L, 71650L, 89363L, 137495L, 51568L,
                                   108862L, 50270L, 35324L, 104145L, 60626L,
                                   355857L, 45231L, 45191L, 69014L, 148697L,
                                   115729L, 221996L, 87059L, 99440L, 198231L,
                                   737699L, 75036L, 38338L, 0L, 91262L, 181633L,
                                   56917L, 197100L, 84115L, 334705L, 8808L, 10723L),
                         PSOE = c(50723L, 150896L, 122361L, 111746L, 63172L,
                                  123708L, 185095L, 251336L, 33693L, 16423L,
                                  111293L, 182850L, 73554L, 39616L, 50951L,
                                  67611L, 56332L, 79715L, 28350L, 17133L, 83956L,
                                  14984L, 44388L, 64766L, 25878L, 44168L, 18210L,
                                  10757L, 76308L, 26225L, 721880L, 60747L, 27809L,
                                  59926L, 107797L, 54827L, 78598L, 20808L, 21079L,
                                  54642L, 731380L, 54720L, 34244L, 93010L, 140643L,
                                  155871L, 36186L, 213242L, 69976L, 395211L,
                                  7886L, 5186L),
                          PCE = c(11926L, 41809L, 59668L, 33879L, 10217L, 29847L,
                                  50990L, 91914L, 7398L, 2442L, 22446L, 60297L,
                                  14046L, 7467L, 10643L, 13971L, 13623L, 15562L,
                                  7927L, 5521L, 21942L, 2406L, 4765L, 12460L, 3744L,
                                  5522L, 2101L, 1196L, 15798L, 2783L, 469361L,
                                  24746L, 22680L, 41345L, 21932L, 6797L, 16777L,
                                  2949L, 2627L, 11835L, 247038L, 6319L, 3906L,
                                  12042L, 29968L, 29840L, 3846L, 50444L, 14029L,
                                  106133L, 0L, 966L),
                           AP = c(14886L, 20424L, 33616L, 24573L, 9415L, 26422L,
                                  34838L, 42860L, 7223L, 15180L, 34857L, 77932L,
                                  28472L, 15944L, 27828L, 36598L, 16005L, 31310L,
                                  10277L, 12815L, 44091L, 7123L, 28707L, 33285L,
                                  14638L, 15259L, 7407L, 3792L, 20521L, 30677L,
                                  75097L, 7953L, 10067L, 15216L, 21880L, 19516L,
                                  50256L, 36377L, 21502L, 40104L, 242077L, 0L,
                                  7927L, 27048L, 36934L, 30167L, 19925L, 35755L,
                                  14596L, 60410L, 2915L, 2074L)),
                            class = "data.frame", row.names = c(NA, -52L))

seats.ex <- structure(list(UCD = c(3L, 2L, 3L, 4L, 3L, 3L, 3L, 5L, 2L, 2L, 3L,
                                   4L, 4L, 5L, 5L, 3L, 2L, 3L, 3L, 2L, 2L, 3L,
                                   3L, 4L, 2L, 3L, 2L, 3L, 3L, 2L, 5L, 1L, 1L,
                                   2L, 4L, 4L, 6L, 4L, 4L, 6L, 11L, 3L, 2L, 0L,
                                   2L, 4L, 2L, 4L, 2L, 5L, 1L, 1L),
                           PSOE = c(2L, 4L, 3L, 3L, 2L, 4L, 4L, 5L, 1L,
                                   1L, 3L, 4L, 2L, 1L, 2L, 1L, 2L, 2L, 1L, 1L,
                                   2L, 0L, 1L, 1L, 1L, 1L, 1L, 0L, 2L, 1L, 11L,
                                   2L, 1L, 1L, 3L, 1L, 2L, 0L, 0L, 1L, 11L, 2L,
                                   1L, 3L, 3L, 4L, 1L, 4L, 2L, 7L, 0L, 0L),
                           PCE = c(0L, 1L, 1L, 0L, 0L, 0L, 1L, 2L, 0L, 0L, 0L,
                                   1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L,
                                   0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 7L, 0L, 0L,
                                   1L, 0L, 0L, 0L, 0L, 0L, 0L, 4L, 0L, 0L, 0L,
                                   0L, 0L, 0L, 1L, 0L, 1L, 0L, 0L),
                           AP = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L,
                                  1L, 0L, 0L, 0L, 1L, 0L, 0L, 0L, 0L, 1L, 0L,
                                  0L, 1L, 0L, 0L, 0L, 0L, 0L, 1L, 1L, 0L, 0L,
                                  0L, 0L, 0L, 1L, 1L, 1L, 1L, 3L, 0L, 0L, 0L,
                                  1L, 0L, 1L, 0L, 0L, 1L, 0L, 0L)),
                           class = "data.frame", row.names = c(NA, -52L))
 census.ex <- c(239935L, 559590L, 451021L, 456952L, 255557L, 403142L, 569535L,
                842042L, 153109L, 112376L, 547396L, 783206L, 407899L, 365063L,
                397732L, 327008L, 211249L, 310547L, 151099L, 95061L, 309595L,
                130998L, 238885L, 364127L, 125385L, 241301L, 99408L, 73992L,
                295410L, 164706L, 3004988L, 304448L, 242148L, 331744L, 413193L,
                279372L, 731499L, 302293L, 315033L, 548711L, 2744152L, 319222L,
                153080L, 437592L, 749572L, 551021L, 167030L, 677156L, 283161L,
                1287981L, 31672L, 25368L)

example <- distortion(votes.ex, seats.ex, census.ex)
p <- plot(example, show.plot = FALSE)
p

}
\author{
Jose M. Pavia, \email{pavia@uv.es}

Alberto Penades, \email{alberto.penades@gmail.com}
}
