% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_funcs.R
\name{summary.emc}
\alias{summary.emc}
\title{Summary Statistics for emc Objects}
\usage{
\method{summary}{emc}(
  object,
  selection = c("mu", "sigma2", "alpha"),
  probs = c(0.025, 0.5, 0.975),
  digits = 3,
  ...
)
}
\arguments{
\item{object}{An object of class \code{emc}}

\item{selection}{A character string indicating the parameter type
Defaults to \code{mu}, \code{sigma2}, and \code{alpha}. See below for more information.}

\item{probs}{The quantiles to be computed. Defaults to the the 2.5\%, 50\% and 97.5\% quantiles.}

\item{digits}{An integer specifying rounding of output.}

\item{...}{Optional arguments that can be passed to \code{get_pars}}
}
\value{
A list of summary output.
}
\description{
Computes quantiles, \code{Rhat} and \code{ESS} for selected model parameters.
}
\details{
Note that if \code{selection = alpha} and \code{by_subject = TRUE} (default)
is used, summary statistics are computed at the individual level.
to the console but summary statistics for all subjects are returned by the
function.

If an emc object that has not been run with \code{fit} yet is supplied, summary of
the design will be returned.
}
