% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{make_ssm_data}
\alias{make_ssm_data}
\title{Generates data from a sample selection model (SSM).}
\usage{
make_ssm_data(
  n_obs = 8000,
  dim_x = 100,
  theta = 1,
  mar = TRUE,
  return_type = "DoubleMLData"
)
}
\arguments{
\item{n_obs}{(\code{integer(1)}) \cr
The number of observations to simulate.}

\item{dim_x}{(\code{integer(1)}) \cr
The number of covariates.}

\item{theta}{(\code{numeric(1)}) \cr
The value of the causal parameter.}

\item{mar}{(\code{logical(1)}) \cr
Indicates whether missingness at random holds.}

\item{return_type}{(\code{character(1)}) \cr
If \code{"DoubleMLData"}, returns a \code{DoubleMLData} object.
If \code{"data.frame"} returns a \code{data.frame()}.
If \code{"data.table"} returns a \code{data.table()}.
Default is \code{"DoubleMLData"}.}
}
\value{
Depending on the \code{return_type}, returns an object or set of objects as specified.
}
\description{
The data generating process is defined as:
}
\details{
\deqn{
y_i = \theta d_i + x_i' \beta  + u_i,}

\deqn{s_i = 1\lbrace d_i + \gamma z_i + x_i' \beta  + v_i > 0 \rbrace,}

\deqn{d_i = 1\lbrace x_i' \beta  + w_i > 0 \rbrace,}

with \eqn{y_i} being observed if \eqn{s_i = 1} and covariates \eqn{x_i \sim \mathcal{N}(0, \Sigma^2_x)}, where
\eqn{\Sigma^2_x} is a matrix with entries
\eqn{\Sigma_{kj} = 0.5^{|j-k|}}.
\eqn{\beta} is a \code{dim_x}-vector with entries \eqn{\beta_j=\frac{0.4}{j^2}}
\eqn{z_i \sim \mathcal{N}(0, 1)},
\eqn{(u_i,v_i) \sim \mathcal{N}(0, \Sigma^2_{u,v})},
\eqn{w_i \sim \mathcal{N}(0, 1)}.

The data generating process is inspired by a process used in the simulation study (see Appendix E) of Bia,
Huber and Lafférs (2023).
}
\references{
Michela Bia, Martin Huber & Lukáš Lafférs (2023) Double Machine Learning for Sample Selection Models,
Journal of Business & Economic Statistics, DOI: 10.1080/07350015.2023.2271071
}
