% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh_set.R
\name{min_dist.mesh}
\alias{min_dist.mesh}
\title{Compute distance between a point and a mesh}
\usage{
min_dist.mesh(p, mesh, norm = rep(1, ncol(mesh$p)))
}
\arguments{
\item{p}{point to compute distance from}

\item{mesh}{mesh to compute distance to}

\item{norm}{vector of weights for each dimension (default: 1)}
}
\value{
distance between x and mesh
}
\description{
Compute distance between a point and a mesh
}
\examples{
 x = matrix(0,ncol=2)
 m = list(p = matrix(c(0,1,1,0,1,1),ncol=2,byrow=TRUE), tri = matrix(c(1,2,3),nrow=1))
 plot2d_mesh(m)
 points(x)
 min = min_dist.mesh(x,m)
 lines(rbind(x,attr(min,"proj")),col='red')

 m = mesh_exsets(function(x) (0.25+x[1])^2+(0.5+x[2]/2)^2, vec=FALSE,
                 1 ,1, intervals=rbind(cbind(0,0),cbind(1,1)), num_workers=1)
 plot2d_mesh(m)
 x = matrix(c(0.25,0.25),ncol=2)
 points(x)
 min = min_dist.mesh(x,m)
 lines(rbind(x,attr(min,"proj")),col='red')
}
