% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osdr_lfm.R
\name{osdr_lfm}
\alias{osdr_lfm}
\title{Online Sufficient Dimension Reduction for Laplace Factor Models (OSDR-LFM)}
\usage{
osdr_lfm(
  X,
  Y = NULL,
  laplace_type = c("symmetric", "asymmetric", "skewed"),
  K_max = NULL,
  H = NULL,
  method_svd = c("gradient", "perturbation"),
  is_distributed = FALSE,
  node_id = 1,
  sync_interval = 50,
  verbose = FALSE
)
}
\arguments{
\item{X}{numeric matrix (n x p), observations in rows.}

\item{Y}{optional numeric vector (n) of proxy responses (e.g., factor scores). 
If NULL, uses norm of projection as proxy (unsupervised LFM mode).}

\item{laplace_type}{character; one of "symmetric", "asymmetric", or "skewed".}

\item{K_max}{integer; maximum candidate dimension (default = min(10, p)).}

\item{H}{integer; number of slices for SIR (default = max(5, floor(sqrt(n)))).}

\item{method_svd}{character; "perturbation" or "gradient" (default = "gradient").}

\item{is_distributed}{logical; if TRUE, simulate distributed node behavior.}

\item{node_id}{integer; node identifier (only used if is_distributed = TRUE).}

\item{sync_interval}{integer; how often to "aggregate" in distributed mode (ignored if not distributed).}

\item{verbose}{logical; print progress.}
}
\value{
list with B_hat (p x K_est), K_est, lambda_trace, and (if distributed) local_B.
}
\description{
Implements an online SIR-based sufficient dimension reduction method tailored for Laplace Factor Models (LFM) with symmetric, asymmetric, or skewed error structures.
Supports distributed deployment via local updates and global aggregation.
}
\examples{
set.seed(42)
n <- 600; p <- 30; m <- 4
A <- qr.Q(qr(matrix(rnorm(p * m), p, m)))
F <- matrix(rnorm(n * m), n, m)
eps <- matrix(rexp(n * p) - rexp(n * p), n, p)
X <- F \%*\% t(A) + eps

out <- osdr_lfm(X, laplace_type = "asymmetric", K_max = 6, verbose = TRUE)
cat("Estimated K:", out$K_est, "\n")

}
