% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pro_flux.R
\name{pro_flux}
\alias{pro_flux}
\alias{pro_flux.cfp_dat}
\alias{pro_flux.cfp_pfres}
\alias{pro_flux.cfp_pfmod}
\title{Inverse model of production profiles}
\usage{
pro_flux(x, ...)

\method{pro_flux}{cfp_dat}(x, ...)

\method{pro_flux}{cfp_pfres}(x, ...)

\method{pro_flux}{cfp_pfmod}(x, ...)
}
\arguments{
\item{x}{A \code{cfp_dat} object with all the necessary input datasets.}

\item{...}{
  Arguments passed on to \code{\link[=cfp_pfmod]{cfp_pfmod}}
  \describe{
    \item{\code{zero_flux}}{(logical) Applies the zero-flux boundary condition? If
\code{FALSE}, \code{F0} is optimized alongside the production rates.}
    \item{\code{zero_limits}}{(numeric vector) a vector of length 2 defining the lower
and upper limit of the lowest flux if \code{zero_flux = FALSE}.}
    \item{\code{DSD0_optim}}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
    \item{\code{evenness_factor}}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}(numeric) A user
defined factor used to penalise strong differences between the optimised
production rates. This must be identified by trial-and-error and can help
prevent that production rates are simply set to zero basically the lower a
production is relative to the the maximum of the absolute of all
productions, the higher it is penalised. The \code{evenness_factor} then
defines the weight of this penalty in the optimisation algorithm
\code{\link{prod_optim}}.}
  }}
}
\value{
A \code{\link[=cfp_pfres]{cfp_pfres()}} model result.
}
\description{
This implements an inverse modeling approach which optimizes
vertically resolved production (or consumption) of the gases in question to
fit a modeled concentration profile to observed data.

One boundary condition of this model is, that there is no incoming or
outgoing flux at the bottom of the lowest layer of the profile. If this
boundary condition is not met, the flux must be optimised as well. This can
be set in \code{zero_flux}.
}
\examples{

soilphys <-
 cfp_soilphys(
   ConFluxPro::soilphys,
   id_cols = c("site", "Date")
 )

gasdata <-
 cfp_gasdata(
   ConFluxPro::gasdata,
   id_cols = c("site", "Date")
 )


lmap <-
 cfp_layers_map(
   ConFluxPro::layers_map,
   gas = "CO2",
   lowlim = 0,
   highlim = 1000,
   id_cols = "site"
 )

PROFLUX <-
 cfp_dat(gasdata,
         soilphys,
         lmap ) |>
 pro_flux()


}
\seealso{
Other flux models: 
\code{\link{fg_flux}()}
}
\concept{flux models}
