% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R, R/cfp_altres.R, R/cfp_dat.R,
%   R/cfp_fgmod.R, R/cfp_pfmod.R, R/cfp_run_map.R
\name{extractors}
\alias{extractors}
\alias{cfp_og_model}
\alias{cfp_og_model.cfp_altres}
\alias{cfp_id_cols}
\alias{cfp_gases}
\alias{cfp_modes}
\alias{cfp_param}
\alias{cfp_funs}
\alias{cfp_zero_flux}
\alias{cfp_zero_limits}
\alias{cfp_DSD0_optim}
\alias{cfp_evenness_factor}
\alias{cfp_known_flux_factor}
\alias{cfp_runmap_type}
\alias{cfp_params_df}
\alias{cfp_n_runs}
\alias{cfp_layers_different}
\alias{cfp_layers_from}
\alias{cfp_layers_altmap}
\title{Extract elements from an object}
\usage{
cfp_og_model(x)

\method{cfp_og_model}{cfp_altres}(x)

cfp_id_cols(x)

cfp_gases(x)

cfp_modes(x)

cfp_param(x)

cfp_funs(x)

cfp_zero_flux(x)

cfp_zero_limits(x)

cfp_DSD0_optim(x)

cfp_evenness_factor(x)

cfp_known_flux_factor(x)

cfp_runmap_type(x)

cfp_params_df(x)

cfp_n_runs(x)

cfp_layers_different(x)

cfp_layers_from(x)

cfp_layers_altmap(x)
}
\arguments{
\item{x}{An object from which to extract the information.}
}
\value{
The extracted component, e.g. a \code{data.frame()} or
\code{character()}.
}
\description{
These functions extract components from
different objects that can be created in ConFluxPro.
}
\examples{
my_data <- ConFluxPro::base_dat |>
  filter(Date == "2021-01-01") # subset for example = faster runtime

### from cfp_dat objects (and derivatives)
cfp_id_cols(my_data)

cfp_gasdata(my_data) |> head()
cfp_soilphys(my_data) |> head()
cfp_layers_map(my_data) |> head()
my_data$profiles |> head()

### from cfp_pfmod or cfp_pfres objects
PROFLUX <- my_data |> pro_flux()
cfp_zero_flux(PROFLUX)
cfp_zero_limits(PROFLUX)
cfp_DSD0_optim(PROFLUX) #deprecated
cfp_evenness_factor(PROFLUX)
cfp_known_flux_factor(PROFLUX)
PROFLUX$PROFLUX |> head()

### from cfp_fgmod or cfp_fgres objects
FLUX <- my_data |> fg_flux()

cfp_gases(FLUX)
cfp_modes(FLUX)
cfp_param(FLUX)
cfp_funs(FLUX)
FLUX$FLUX |> head()

### from cfp_run_map
set.seed(42)
my_run_map <-
cfp_run_map(
  PROFLUX,
  list("TPS" = c(0.9, 1.1)),
  "factor",
  n_runs = 2)

cfp_params_df(my_run_map)
cfp_n_runs(my_run_map)
cfp_layers_from(my_run_map)
cfp_layers_different(my_run_map)
cfp_runmap_type(my_run_map)
cfp_layers_altmap(my_run_map)

### from cfp_altres
my_altres <-
alternate(
  x = PROFLUX,
  f = \(x) complete_soilphys(x, "a+AFPS^b", quiet = TRUE),
  run_map = my_run_map)

cfp_og_model(my_altres)
cfp_run_map(my_altres)

}
